# 📤 Configuração do Google Drive para Backups

## 📋 Pré-requisitos

1. Conta Google (Gmail)
2. Acesso ao [Google Cloud Console](https://console.cloud.google.com)

---

## 🔧 Passo a Passo de Configuração

### 1. Criar Projeto no Google Cloud Console

1. Acesse: https://console.cloud.google.com
2. Clique em "Selecionar projeto" → "Novo projeto"
3. Dê um nome (ex: "SGE Backups")
4. Clique em "Criar"

### 2. Ativar API do Google Drive

1. No menu lateral, vá em **"APIs e Serviços"** → **"Biblioteca"**
2. Procure por **"Google Drive API"**
3. Clique em **"Ativar"**

### 3. Criar Credenciais OAuth 2.0

1. Vá em **"APIs e Serviços"** → **"Credenciais"**
2. Clique em **"Criar credenciais"** → **"ID do cliente OAuth 2.0"**
3. Se solicitado, configure a tela de consentimento:
   - Tipo de usuário: **Interno** (se for conta Google Workspace) ou **Externo**
   - Preencha os dados básicos
   - Adicione seu email como usuário de teste
4. Configure o ID do cliente:
   - **Tipo de aplicativo:** Aplicativo da Web
   - **Nome:** SGE Backups (ou qualquer nome)
   - **URIs de redirecionamento autorizados:** 
     ```
     http://localhost:8000/superadmin/backups/google-drive/callback
     ```
     (Substitua pela URL do seu sistema em produção)

5. Clique em **"Criar"**
6. **Copie o Client ID e Client Secret** (você precisará deles!)

### 4. Configurar no Sistema

1. Acesse: **Superadmin → Backups → Google Drive**
2. Cole o **Client ID** e **Client Secret**
3. Clique em **"Salvar Configurações"**
4. Clique em **"Autenticar com Google Drive"**
5. Selecione a conta Google
6. Autorize o acesso
7. Você será redirecionado de volta ao sistema

### 5. Configurar Pasta (Opcional)

1. No Google Drive, crie uma pasta para os backups (ex: "Backups SGE")
2. Abra a pasta
3. Na URL, copie o ID após `/folders/`
   - Exemplo: `https://drive.google.com/drive/folders/1BxiMVs0XRA5nFMdKvBdBZjgmUUqptlbs74OgvE2upms`
   - O ID é: `1BxiMVs0XRA5nFMdKvBdBZjgmUUqptlbs74OgvE2upms`
4. Cole o ID no campo **"ID da Pasta"**
5. Clique em **"Salvar Configurações"**

---

## ✅ Como Funciona

Após configurado:

1. **Backup Criado** → Sistema cria backup localmente
2. **Upload Automático** → Se Google Drive estiver habilitado, envia automaticamente
3. **Organização** → Backups salvos na pasta configurada (ou raiz do Drive)
4. **Segurança** → Apenas a conta autorizada tem acesso

---

## 🔒 Segurança

- ✅ Credenciais armazenadas de forma segura
- ✅ Acesso apenas à pasta configurada
- ✅ Tokens renovados automaticamente
- ✅ Logs de todas as operações

---

## 🆘 Solução de Problemas

### Erro: "Credenciais não configuradas"
- Verifique se Client ID e Client Secret estão corretos
- Certifique-se de que salvou as configurações

### Erro: "Token inválido"
- Clique em "Autenticar" novamente
- O token pode ter expirado

### Erro: "Pasta não encontrada"
- Verifique se o ID da pasta está correto
- Certifique-se de que a conta autorizada tem acesso à pasta

### Upload não funciona
- Verifique se a API do Google Drive está ativada
- Verifique os logs em `storage/logs/laravel.log`
- Certifique-se de que há espaço no Google Drive

---

## 📝 Notas Importantes

- **URL de Redirecionamento:** Deve ser exatamente igual à configurada no Google Cloud Console
- **Produção:** Altere a URL para o domínio real do sistema
- **Espaço:** Verifique o espaço disponível no Google Drive
- **Limite:** Google Drive tem limite de 15 GB (gratuito) ou mais (planos pagos)

---

## 🎯 Benefícios

- ✅ Backups automáticos na nuvem
- ✅ Redundância (backup local + nuvem)
- ✅ Acesso de qualquer lugar
- ✅ Organização automática
- ✅ Segurança do Google
