# Como Resetar Todas as Tabelas do Banco de Dados

Este documento explica como fazer reset completo de todas as tabelas do banco de dados, removendo **todos os dados** (incluindo soft-deleted records).

## ⚠️ ATENÇÃO

**Este processo é IRREVERSÍVEL!** Todos os dados serão permanentemente removidos do banco de dados, incluindo:
- Alunos e seus usuários
- Professores e seus usuários
- Funcionários e seus usuários (exceto admins/superadmins)
- Turmas
- Disciplinas
- Avaliações
- Trabalhos
- Horários
- Eventos
- Registros financeiros
- Pagamentos
- Mensagens
- Notificações
- **E TUDO MAIS!**

**⚠️ IMPORTANTE:** Admins e Superadmins NÃO serão removidos! Eles serão preservados junto com suas roles e permissões.

## 📋 Métodos Disponíveis

### Método 1: Usando o Comando Artisan (Recomendado)

```bash
php artisan db:reset
```

Este comando irá:
1. Pedir confirmação duas vezes (por segurança)
2. Limpar todas as tabelas
3. Remover todos os arquivos relacionados (fotos, documentos, etc.)
4. Mostrar um resumo do que foi feito

**Para forçar sem confirmação:**
```bash
php artisan db:reset --force
```

### Método 2: Usando o Seeder Diretamente

```bash
php artisan db:seed --class=ResetarTodasTabelasSeeder
```

## 🔄 Após o Reset

Após resetar o banco de dados, você precisará popular novamente as tabelas básicas:

```bash
# 1. Criar roles e permissions (se ainda não existirem)
php artisan db:seed --class=RolePermissionSeeder

# 2. Criar superadmin (se ainda não existir)
php artisan db:seed --class=SuperadminSeeder

# 3. Criar admin (se ainda não existir)
php artisan db:seed --class=AdminSeeder

# 4. Criar ano letivo
php artisan db:seed --class=AnoLetivoSeeder

# 5. Criar disciplinas
php artisan db:seed --class=DisciplinaSeeder

# 6. Popular com dados de teste (opcional)
php artisan db:seed --class=AlunoSeeder
php artisan db:seed --class=ProfessorSeeder
```

**Nota:** Se você já tem admins/superadmins no sistema, eles serão preservados e você não precisa executar os seeders de SuperadminSeeder e AdminSeeder novamente.

## 📝 O Que o Reset Faz

O seeder `ResetarTodasTabelasSeeder` faz o seguinte:

1. **Desabilita verificação de foreign keys** temporariamente
2. **Limpa todas as tabelas pivot** (turma_aluno, turma_disciplina, etc.)
3. **Remove todos os registros financeiros** (financeiro, payments, invoices, professor_payments)
4. **Remove avaliações, trabalhos e planos trimestrais**
5. **Remove horários e eventos**
6. **Remove mensagens e notificações**
7. **Faz hard delete de alunos** (incluindo soft-deleted) e remove fotos
8. **Faz hard delete de professores** (incluindo soft-deleted) e remove documentos
9. **Faz hard delete de funcionários** (incluindo soft-deleted, **exceto admins/superadmins**)
10. **Faz hard delete de turmas** (incluindo soft-deleted)
11. **Faz hard delete de disciplinas** (incluindo soft-deleted)
12. **Remove trimestres e anos letivos**
13. **Faz hard delete de todos os usuários** (incluindo soft-deleted, **exceto admins/superadmins**)
14. **Limpa tabelas auxiliares** (auditoria, login_attempts, sessions)
15. **Preserva roles e permissões** de admins/superadmins na tabela `user_role`

## 🗂️ Tabelas que NÃO são Limpas (por padrão)

As seguintes tabelas são mantidas (comente no seeder se quiser limpar também):
- `configuracoes` - Configurações do sistema
- `temas` - Temas do sistema
- `roles` - Roles do sistema
- `permissions` - Permissões do sistema

## 💡 Dicas

1. **Faça backup antes de resetar:**
   ```bash
   # Exportar banco de dados
   mysqldump -u usuario -p nome_banco > backup.sql
   ```

2. **Para resetar apenas dados de teste:**
   Use o seeder `ApagarTodosDadosExcetoFuncionariosEAdminsSeeder` que mantém funcionários e admins.

3. **Para desenvolvimento:**
   Você pode usar `php artisan migrate:fresh --seed` que recria todas as tabelas e popula com dados iniciais.

## 🐛 Resolução de Problemas

### Erro: "Foreign key constraint fails"
- O seeder já desabilita as foreign keys automaticamente
- Se ainda ocorrer, verifique se há algum processo bloqueando as tabelas

### Erro: "Table doesn't exist"
- Isso é normal se a tabela não foi criada ainda
- O seeder ignora tabelas que não existem

### Dados ainda aparecem após reset
- Certifique-se de que o reset foi executado completamente
- Verifique se há outros processos inserindo dados
- Execute `php artisan db:reset --force` novamente

## 📞 Suporte

Se encontrar problemas, verifique:
1. Logs do Laravel: `storage/logs/laravel.log`
2. Permissões do banco de dados
3. Se o banco de dados está acessível
