<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Professor;
use App\Models\Role;

class AdicionarRoleProfessorATodos extends Command
{
    protected $signature = 'professor:adicionar-role-todos';
    protected $description = 'Adiciona a role "professor" a todos os usuários que são professores';

    public function handle()
    {
        $roleProfessor = Role::where('slug', 'professor')->first();
        
        if (!$roleProfessor) {
            $this->error('Role "professor" não encontrada no banco de dados!');
            return 1;
        }
        
        $this->info("Role 'professor' encontrada: ID {$roleProfessor->id}");
        
        $professores = Professor::with('user')->get();
        $total = $professores->count();
        $adicionados = 0;
        $jaTinham = 0;
        $semUser = 0;
        
        $this->info("Processando {$total} professores...\n");
        
        $bar = $this->output->createProgressBar($total);
        $bar->start();
        
        foreach ($professores as $professor) {
            if (!$professor->user) {
                $semUser++;
                $bar->advance();
                continue;
            }
            
            $user = $professor->user;
            
            // Recarregar relacionamento roles
            $user->load('roles');
            
            if (!$user->roles->contains($roleProfessor->id)) {
                $user->roles()->attach($roleProfessor->id);
                $adicionados++;
            } else {
                $jaTinham++;
            }
            
            $bar->advance();
        }
        
        $bar->finish();
        $this->newLine(2);
        
        $this->info("✓ Processamento concluído!");
        $this->line("  - Total de professores: {$total}");
        $this->line("  - Roles adicionadas: {$adicionados}");
        $this->line("  - Já tinham a role: {$jaTinham}");
        $this->line("  - Sem user associado: {$semUser}");
        
        return 0;
    }
}
