<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Aluno;
use App\Models\Professor;
use Illuminate\Support\Facades\DB;

class DiagnosticarStatusUsuarios extends Command
{
    protected $signature = 'users:diagnosticar-status';
    protected $description = 'Diagnostica o status de alunos e professores';

    public function handle()
    {
        $this->info("=== DIAGNÓSTICO DE STATUS ===");
        
        // Verificar diretamente no banco
        $this->info("\n1. Verificando diretamente no banco de dados:");
        $usersDb = DB::table('users')
            ->join('user_role', 'users.id', '=', 'user_role.user_id')
            ->join('roles', 'user_role.role_id', '=', 'roles.id')
            ->whereIn('roles.slug', ['aluno', 'professor'])
            ->select('users.id', 'users.name', 'users.is_active', 'roles.slug as role')
            ->limit(10)
            ->get();
        
        foreach ($usersDb as $user) {
            $status = $user->is_active ? 'ATIVO' : 'BLOQUEADO';
            $this->line("  - ID: {$user->id}, Nome: {$user->name}, Role: {$user->role}, is_active (DB): {$user->is_active}, Status: {$status}");
        }
        
        // Verificar via modelos
        $this->info("\n2. Verificando via modelos Eloquent:");
        $alunos = Aluno::with('user')->limit(5)->get();
        foreach ($alunos as $aluno) {
            if ($aluno->user) {
                $status = $aluno->user->is_active ? 'ATIVO' : 'BLOQUEADO';
                $this->line("  - Aluno ID: {$aluno->id}, User ID: {$aluno->user->id}, is_active: " . var_export($aluno->user->is_active, true) . ", Status: {$status}");
            } else {
                $this->warn("  - Aluno ID: {$aluno->id} SEM USER!");
            }
        }
        
        $professores = Professor::with('user')->limit(5)->get();
        foreach ($professores as $professor) {
            if ($professor->user) {
                $status = $professor->user->is_active ? 'ATIVO' : 'BLOQUEADO';
                $this->line("  - Professor ID: {$professor->id}, User ID: {$professor->user->id}, is_active: " . var_export($professor->user->is_active, true) . ", Status: {$status}");
            } else {
                $this->warn("  - Professor ID: {$professor->id} SEM USER!");
            }
        }
        
        // Verificar cast
        $this->info("\n3. Verificando cast do campo is_active:");
        $userModel = \App\Models\User::first();
        if ($userModel) {
            $this->line("  - Tipo do campo is_active: " . gettype($userModel->is_active));
            $this->line("  - Valor: " . var_export($userModel->is_active, true));
        }
        
        return 0;
    }
}
