<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FuncionarioPayment;
use App\Models\FuncionarioServicoPayment;
use App\Models\ProfessorPayment;
use Illuminate\Http\Request;

class PaymentsDashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin,superadmin,funcionario']);
    }

    public function index(Request $request)
    {
        $mes = (int) $request->get('mes', date('m'));
        $ano = (int) $request->get('ano', date('Y'));

        $meses = ['', 'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho',
            'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
        $mesNome = $meses[$mes] ?? (string) $mes;

        $isAdmin = auth()->user() && (auth()->user()->isAdmin() || auth()->user()->isSuperadmin());

        // Professores (disponível também para funcionário com permissão)
        $profPendentes = ProfessorPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PENDENTE')->count();
        $profPagos = ProfessorPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->count();

        // Funcionários (serviços) e Administração (apenas admin/superadmin)
        $funcPendentes = $isAdmin ? FuncionarioServicoPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PENDENTE')->count() : null;
        $funcPagos = $isAdmin ? FuncionarioServicoPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->count() : null;

        $admPendentes = $isAdmin ? FuncionarioPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PENDENTE')->count() : null;
        $admPagos = $isAdmin ? FuncionarioPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->count() : null;

        // Totais financeiros (apenas pagos)
        $totalBruto = ProfessorPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('valor_total');
        $totalINSS = ProfessorPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('inss');
        $totalIRPS = ProfessorPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('irps');
        $totalLiquido = ProfessorPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('valor_liquido');

        if ($isAdmin) {
            $totalBruto += FuncionarioServicoPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('valor_total');
            $totalINSS += FuncionarioServicoPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('inss');
            $totalIRPS += FuncionarioServicoPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('irps');
            $totalLiquido += FuncionarioServicoPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('valor_liquido');

            $totalBruto += FuncionarioPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('valor_total');
            $totalINSS += FuncionarioPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('inss');
            $totalIRPS += FuncionarioPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('irps');
            $totalLiquido += FuncionarioPayment::where('mes', $mes)->where('ano', $ano)->where('status', 'PAGO')->sum('valor_liquido');
        }

        return view('admin.payments.index', compact(
            'mes',
            'ano',
            'mesNome',
            'isAdmin',
            'profPendentes',
            'profPagos',
            'funcPendentes',
            'funcPagos',
            'admPendentes',
            'admPagos',
            'totalBruto',
            'totalINSS',
            'totalIRPS',
            'totalLiquido'
        ));
    }
}

