<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Configuracao;
use Symfony\Component\HttpFoundation\Response;

class CheckMaintenanceMode
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Verificar se modo de manutenção está ativo
        $manutencaoAtiva = Configuracao::get('manutencao_ativa', false);
        
        if ($manutencaoAtiva) {
            // Permitir acesso a superadmin sempre
            if (Auth::check() && Auth::user()->tipo === 'superadmin') {
                return $next($request);
            }
            
            // Permitir acesso à rota de login para superadmin poder fazer login
            if ($request->is('login') || $request->is('logout')) {
                return $next($request);
            }
            
            // Permitir acesso às rotas de manutenção e configurações do superadmin
            if ($request->is('manutencao') || $request->is('superadmin/manutencao*') || $request->is('superadmin/configuracoes*')) {
                return $next($request);
            }
            
            // Redirecionar todos os outros usuários para página de manutenção
            return response()->view('manutencao', [], 503);
        }
        
        return $next($request);
    }
}
