<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Auditoria;

class LogAuditoria
{
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        // Log apenas para métodos que modificam dados
        if (in_array($request->method(), ['POST', 'PUT', 'PATCH', 'DELETE'])) {
            $acao = $this->getAcao($request->method());
            
            Auditoria::create([
                'user_id' => auth()->id(),
                'acao' => $acao,
                'modelo' => $this->getModelo($request),
                'modelo_id' => $this->getModeloId($request),
                'dados_novos' => json_encode($request->except(['password', '_token'])),
                'ip_address' => $request->ip(),
                'user_agent' => $request->userAgent(),
            ]);
        }

        return $response;
    }

    private function getAcao(string $method): string
    {
        return match($method) {
            'POST' => 'CREATE',
            'PUT', 'PATCH' => 'UPDATE',
            'DELETE' => 'DELETE',
            default => 'UNKNOWN',
        };
    }

    private function getModelo(Request $request): ?string
    {
        $route = $request->route();
        if ($route) {
            $controller = $route->getController();
            if ($controller) {
                $className = class_basename($controller);
                return str_replace('Controller', '', $className);
            }
        }
        return null;
    }

    private function getModeloId(Request $request): ?int
    {
        $route = $request->route();
        if ($route) {
            $parameters = $route->parameters();
            foreach (['id', 'user', 'aluno', 'professor', 'turma', 'disciplina'] as $key) {
                if (isset($parameters[$key])) {
                    return (int) $parameters[$key];
                }
            }
        }
        return null;
    }
}



