<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Configuracao extends Model
{
    use HasFactory;

    protected $table = 'configuracoes';

    protected $fillable = [
        'chave',
        'valor',
        'tipo',
        'descricao',
    ];

    public static function get($chave, $default = null)
    {
        $config = self::where('chave', $chave)->first();
        
        if (!$config) {
            return $default;
        }

        switch ($config->tipo) {
            case 'integer':
                return (int) $config->valor;
            case 'boolean':
                return filter_var($config->valor, FILTER_VALIDATE_BOOLEAN);
            case 'json':
                return json_decode($config->valor, true);
            default:
                return $config->valor;
        }
    }

    public static function set($chave, $valor, $tipo = 'string', $descricao = null)
    {
        if ($tipo === 'json') {
            $valor = json_encode($valor);
        } elseif ($tipo === 'boolean') {
            $valor = $valor ? '1' : '0';
        } else {
            $valor = (string) $valor;
        }

        return self::updateOrCreate(
            ['chave' => $chave],
            [
                'valor' => $valor,
                'tipo' => $tipo,
                'descricao' => $descricao,
            ]
        );
    }
}



