<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Financeiro extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'financeiro';

    protected $fillable = [
        'aluno_id',
        'ano_letivo_id',
        'tipo',
        'descricao',
        'valor',
        'data_vencimento',
        'status',
        'data_pagamento',
        'valor_pago',
        'observacoes',
    ];

    protected $casts = [
        'valor' => 'decimal:2',
        'valor_pago' => 'decimal:2',
        'data_vencimento' => 'date',
        'data_pagamento' => 'date',
    ];

    public function aluno()
    {
        return $this->belongsTo(Aluno::class);
    }

    public function anoLetivo()
    {
        return $this->belongsTo(AnoLetivo::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
}



