<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FuncionarioServico extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'funcionarios_servicos';

    protected $fillable = [
        'nome',
        'cargo',
        'salario_base',
        'numero_dependentes',
        'telefone',
        'endereco',
        'is_active',
    ];

    protected $casts = [
        'salario_base' => 'decimal:2',
        'numero_dependentes' => 'integer',
        'is_active' => 'boolean',
    ];
}

