<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'type',
        'title',
        'message',
        'link',
        'read',
        'read_at',
        'data',
    ];

    protected $casts = [
        'read' => 'boolean',
        'read_at' => 'datetime',
        'data' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function markAsRead()
    {
        if (!$this->read) {
            $this->update([
                'read' => true,
                'read_at' => now(),
            ]);
        }
    }

    /**
     * Criar notificação de pagamento
     */
    public static function criarNotificacaoPagamento($userId, $tipoPagamento, $valor, $alunoNome, $metodo, $link = null)
    {
        // Normalizar método
        $metodoNormalizado = strtoupper($metodo);
        if ($metodoNormalizado === 'OUTRO') {
            $metodoNormalizado = 'PRESENCIAL';
        }
        
        $tipo = 'payment_' . strtolower($metodoNormalizado);
        
        $tipoTextos = [
            'payment_mpesa' => 'Pagamento via M-Pesa',
            'payment_emola' => 'Pagamento via Emola',
            'payment_presencial' => 'Pagamento Presencial',
        ];

        $title = $tipoTextos[$tipo] ?? 'Novo Pagamento';
        
        $message = "Pagamento de " . number_format($valor, 2, ',', '.') . " MT registrado";
        if ($alunoNome) {
            $message .= " para o aluno " . $alunoNome;
        }
        $message .= " via " . ($metodoNormalizado === 'MPESA' ? 'M-Pesa' : ($metodoNormalizado === 'EMOLA' ? 'Emola' : 'Presencial')) . ".";

        return self::create([
            'user_id' => $userId,
            'type' => $tipo,
            'title' => $title,
            'message' => $message,
            'link' => $link,
            'data' => [
                'metodo' => $metodoNormalizado,
                'valor' => $valor,
                'aluno_nome' => $alunoNome,
            ],
        ]);
    }
}
