<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'aluno_id',
        'financeiro_id',
        'invoice_id',
        'reference',
        'metodo',
        'valor',
        'status',
        'transaction_id',
        'callback_data',
        'data_pagamento',
        'observacoes',
    ];

    protected $casts = [
        'valor' => 'decimal:2',
        'callback_data' => 'array',
        'data_pagamento' => 'datetime',
    ];

    public function aluno()
    {
        return $this->belongsTo(Aluno::class);
    }

    public function financeiro()
    {
        return $this->belongsTo(Financeiro::class);
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    /**
     * Gera uma referência única para o pagamento
     */
    public static function gerarReferencia(): string
    {
        do {
            $reference = 'PAY' . date('Ymd') . strtoupper(substr(uniqid(), -8));
        } while (self::where('reference', $reference)->exists());

        return $reference;
    }

    /**
     * Verifica se o pagamento foi aprovado
     */
    public function isAprovado(): bool
    {
        return $this->status === 'APROVADO';
    }
}
