<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tema extends Model
{
    use HasFactory;

    protected $table = 'temas';

    protected $fillable = [
        'nome',
        'cor_principal',
        'cor_secundaria',
        'ativo',
    ];

    protected $casts = [
        'ativo' => 'boolean',
    ];

    public static function getTemaAtivo()
    {
        return self::where('ativo', true)->first() ?? self::getTemaDefault();
    }

    public static function getTemaDefault()
    {
        return new self([
            'nome' => 'Default',
            'cor_principal' => '#6c757d',
            'cor_secundaria' => null,
            'ativo' => true,
        ]);
    }
}



