<?php

namespace App\Services;

use App\Models\Avaliacao;

class AvaliacaoService
{
    /**
     * Calcula a média do sistema nacional
     */
    public function calcularMediaNacional(Avaliacao $avaliacao): ?float
    {
        if ($avaliacao->modelo !== 'NACIONAL') {
            return null;
        }

        if ($avaliacao->teste1 === null || $avaliacao->teste2 === null || $avaliacao->avaliacao_final === null) {
            return null;
        }

        $media = (($avaliacao->teste1 + $avaliacao->teste2) * 0.40) + ($avaliacao->avaliacao_final * 0.60);
        return round($media, 2);
    }

    // Cambridge removido

    /**
     * Salva ou atualiza uma avaliação com cálculos automáticos
     */
    public function salvarAvaliacao(array $dados, ?string $nivelEnsino = null): Avaliacao
    {
        $avaliacao = Avaliacao::updateOrCreate(
            [
                'aluno_id' => $dados['aluno_id'],
                'disciplina_id' => $dados['disciplina_id'],
                'turma_id' => $dados['turma_id'],
                'trimestre_id' => $dados['trimestre_id'],
                'ano_letivo_id' => $dados['ano_letivo_id'],
                'modelo' => $dados['modelo'] ?? 'NACIONAL',
            ],
            $dados
        );

        // Calcula MAP (Média A.Prática)
        if (isset($dados['a_pratica_1']) || isset($dados['a_pratica_2'])) {
            $avaliacao->calcularMAP();
        }

        // Calcula MACS (Média ACS)
        if (isset($dados['acs_1']) || isset($dados['acs_2'])) {
            $avaliacao->calcularMACS();
        }

        // Calcula MT (Média Trimestral)
        if ($avaliacao->map !== null && $avaliacao->macs !== null && $avaliacao->at !== null) {
            $avaliacao->calcularMT();
        }

        // Calcula médias conforme o modelo antigo (para compatibilidade)
        if ($avaliacao->teste1 !== null || $avaliacao->teste2 !== null || $avaliacao->avaliacao_final !== null) {
            $avaliacao->media_nacional = $this->calcularMediaNacional($avaliacao);
        }

        if ($nivelEnsino === 'SECUNDARIO' && $avaliacao->media_nacional !== null) {
            // Para secundário, usar a média nacional como MT para manter compatibilidade
            $avaliacao->mt = $avaliacao->media_nacional;
        }

        // Cambridge removido

        $avaliacao->save();

        // Calcula MFRD após salvar todas as avaliações do trimestre
        Avaliacao::calcularMFRD(
            $avaliacao->aluno_id,
            $avaliacao->disciplina_id,
            $avaliacao->turma_id,
            $avaliacao->ano_letivo_id
        );

        return $avaliacao;
    }
}



