<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('alunos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('codigo_estudante', 9)->unique(); // AAAA00001
            $table->string('telefone')->nullable();
            $table->string('endereco')->nullable();
            $table->date('data_nascimento')->nullable();
            $table->enum('genero', ['M', 'F', 'Outro'])->nullable();
            $table->string('nome_encarregado')->nullable();
            $table->string('telefone_encarregado')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('alunos');
    }
};



