<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ano_letivo', function (Blueprint $table) {
            $table->id();
            $table->string('ano', 9); // Ex: 2024/2025
            $table->date('data_inicio');
            $table->date('data_fim');
            $table->boolean('ativo')->default(false);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ano_letivo');
    }
};



