<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('turma_disciplina_professor', function (Blueprint $table) {
            $table->id();
            $table->foreignId('turma_id')->constrained()->onDelete('cascade');
            $table->foreignId('disciplina_id')->constrained('disciplinas')->onDelete('cascade');
            $table->foreignId('professor_id')->constrained('professores')->onDelete('cascade');
            $table->foreignId('ano_letivo_id')->constrained('ano_letivo')->onDelete('cascade');
            $table->timestamps();
            
            $table->unique(['turma_id', 'disciplina_id', 'professor_id', 'ano_letivo_id'], 'tdp_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('turma_disciplina_professor');
    }
};



