<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('avaliacoes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('aluno_id')->constrained('alunos')->onDelete('cascade');
            $table->foreignId('disciplina_id')->constrained('disciplinas')->onDelete('cascade');
            $table->foreignId('turma_id')->constrained()->onDelete('cascade');
            $table->foreignId('trimestre_id')->constrained('trimestres')->onDelete('cascade');
            $table->foreignId('ano_letivo_id')->constrained('ano_letivo')->onDelete('cascade');
            $table->enum('modelo', ['NACIONAL', 'CAMBRIDGE']);
            
            // Sistema Nacional
            $table->decimal('teste1', 5, 2)->nullable();
            $table->decimal('teste2', 5, 2)->nullable();
            $table->decimal('avaliacao_final', 5, 2)->nullable();
            $table->decimal('media_nacional', 5, 2)->nullable();
            
            // Sistema Cambridge
            $table->decimal('midterm_exam', 5, 2)->nullable();
            $table->decimal('term_exam', 5, 2)->nullable();
            $table->decimal('percent_final', 5, 2)->nullable();
            $table->string('letra', 2)->nullable(); // A, B, C, etc.
            $table->decimal('pum', 5, 2)->nullable();
            
            $table->timestamps();
            
            $table->unique(['aluno_id', 'disciplina_id', 'turma_id', 'trimestre_id', 'ano_letivo_id', 'modelo'], 'avaliacoes_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('avaliacoes');
    }
};



