<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('auditoria', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->string('acao'); // CREATE, UPDATE, DELETE, LOGIN, etc.
            $table->string('modelo')->nullable(); // User, Aluno, Avaliacao, etc.
            $table->unsignedBigInteger('modelo_id')->nullable();
            $table->text('dados_anteriores')->nullable(); // JSON
            $table->text('dados_novos')->nullable(); // JSON
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();
            
            $table->index(['user_id', 'created_at']);
            $table->index(['modelo', 'modelo_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('auditoria');
    }
};



