<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('turmas', function (Blueprint $table) {
            // Remove a constraint única do campo codigo
            $table->dropUnique(['codigo']);
            
            // Adiciona uma constraint única composta: codigo + nome + ano_letivo_id
            // Isso permite múltiplas turmas da mesma classe, mas não duplicatas da mesma combinação
            $table->unique(['codigo', 'nome', 'ano_letivo_id'], 'turmas_codigo_nome_ano_unique');
        });
    }

    public function down(): void
    {
        Schema::table('turmas', function (Blueprint $table) {
            // Remove a constraint composta
            $table->dropUnique('turmas_codigo_nome_ano_unique');
            
            // Restaura a constraint única no codigo
            $table->unique('codigo');
        });
    }
};
