<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            // Dados do aluno
            $table->string('local_nascimento')->nullable()->after('data_nascimento');
            $table->string('naturalidade')->nullable()->after('local_nascimento');
            $table->string('distrito_natural')->nullable()->after('naturalidade');
            $table->string('provincia_natural')->nullable()->after('distrito_natural');
            $table->string('num_documento')->nullable()->after('provincia_natural');
            $table->string('local_emissao')->nullable()->after('num_documento');
            $table->date('data_emissao')->nullable()->after('local_emissao');
            $table->string('nome_pai')->nullable()->after('data_emissao');
            $table->string('nome_mae')->nullable()->after('nome_pai');
            
            // Dados do encarregado de educação
            $table->string('endereco_encarregado')->nullable()->after('telefone_encarregado');
            $table->string('profissao_encarregado')->nullable()->after('endereco_encarregado');
            
            // Status de pagamento
            $table->boolean('pago')->default(true)->after('profissao_encarregado');
        });
    }

    public function down(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            $table->dropColumn([
                'local_nascimento',
                'naturalidade',
                'distrito_natural',
                'provincia_natural',
                'num_documento',
                'local_emissao',
                'data_emissao',
                'nome_pai',
                'nome_mae',
                'endereco_encarregado',
                'profissao_encarregado',
                'pago',
            ]);
        });
    }
};
