<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('avaliacoes', function (Blueprint $table) {
            // Novo formato de avaliações
            $table->decimal('a_pratica_1', 5, 2)->nullable()->after('modelo');
            $table->decimal('a_pratica_2', 5, 2)->nullable()->after('a_pratica_1');
            $table->decimal('map', 5, 2)->nullable()->after('a_pratica_2'); // Média A.Prática
            $table->decimal('acs_1', 5, 2)->nullable()->after('map');
            $table->decimal('acs_2', 5, 2)->nullable()->after('acs_1');
            $table->decimal('macs', 5, 2)->nullable()->after('acs_2'); // Média ACS
            $table->decimal('at', 5, 2)->nullable()->after('macs'); // Avaliação Total
            $table->decimal('mt', 5, 2)->nullable()->after('at'); // Média Trimestral
            $table->decimal('mfrd', 5, 2)->nullable()->after('mt'); // Média Final da Disciplina
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('avaliacoes', function (Blueprint $table) {
            $table->dropColumn(['a_pratica_1', 'a_pratica_2', 'map', 'acs_1', 'acs_2', 'macs', 'at', 'mt', 'mfrd']);
        });
    }
};
