<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('funcionarios', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('numero_funcionario')->unique()->nullable();
            $table->string('telefone')->nullable();
            $table->text('endereco')->nullable();
            $table->string('cargo')->nullable();
            
            // Permissões
            $table->boolean('gerir_alunos')->default(false);
            $table->boolean('gerir_professores')->default(false);
            $table->boolean('gerir_turmas')->default(false);
            $table->boolean('gerir_disciplinas')->default(false);
            $table->boolean('gerir_mensalidades')->default(false);
            $table->boolean('gerir_horarios')->default(false);
            $table->boolean('gerir_eventos')->default(false);
            $table->boolean('gerir_planos')->default(false);
            $table->boolean('gerir_avaliacoes')->default(false);
            $table->boolean('gerir_inscricoes')->default(false);
            
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('funcionarios');
    }
};
