<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('aluno_id')->constrained('alunos')->onDelete('cascade');
            $table->foreignId('financeiro_id')->nullable()->constrained('financeiro')->onDelete('set null');
            $table->unsignedBigInteger('invoice_id')->nullable();
            $table->string('reference')->unique(); // Referência única do pagamento
            $table->enum('metodo', ['EMOLA', 'MPESA', 'OUTRO'])->default('MPESA');
            $table->decimal('valor', 10, 2);
            $table->enum('status', ['PENDENTE', 'PROCESSANDO', 'APROVADO', 'REJEITADO', 'CANCELADO'])->default('PENDENTE');
            $table->string('transaction_id')->nullable(); // ID da transação do gateway
            $table->text('callback_data')->nullable(); // Dados retornados pelo gateway
            $table->timestamp('data_pagamento')->nullable();
            $table->text('observacoes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
