<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            $table->enum('modalidade_pagamento', ['MENSAL', 'TRIMESTRAL', 'SEMESTRAL', 'ANUAL'])->default('MENSAL')->after('pago');
            $table->decimal('valor_mensalidade_personalizado', 10, 2)->nullable()->after('modalidade_pagamento');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            $table->dropColumn(['modalidade_pagamento', 'valor_mensalidade_personalizado']);
        });
    }
};
