<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('disciplinas', function (Blueprint $table) {
            // Carga horária semanal em minutos (ou horas, conforme preferência)
            $table->integer('carga_horaria_semanal')->nullable()->after('modelo_avaliacao')
                  ->comment('Carga horária semanal em minutos');
        });
    }

    public function down(): void
    {
        Schema::table('disciplinas', function (Blueprint $table) {
            $table->dropColumn('carga_horaria_semanal');
        });
    }
};
