<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('turma_disciplina', function (Blueprint $table) {
            $table->integer('carga_horaria_semanal')
                ->nullable()
                ->after('ano_letivo_id')
                ->comment('Carga horária semanal em minutos para a turma');
        });
    }

    public function down(): void
    {
        Schema::table('turma_disciplina', function (Blueprint $table) {
            $table->dropColumn('carga_horaria_semanal');
        });
    }
};
