<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('professores', function (Blueprint $table) {
            $table->enum('nivel_ensino', ['PRIMARIO', 'SECUNDARIO', 'AMBOS'])
                ->default('AMBOS')
                ->after('genero');
        });

        DB::table('professores')
            ->whereNull('nivel_ensino')
            ->update(['nivel_ensino' => 'AMBOS']);
    }

    public function down(): void
    {
        Schema::table('professores', function (Blueprint $table) {
            $table->dropColumn('nivel_ensino');
        });
    }
};
