<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('professor_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('professor_id')->constrained('professores')->onDelete('cascade');
            $table->integer('mes')->comment('Mês do pagamento (1-12)');
            $table->integer('ano')->comment('Ano do pagamento');
            $table->decimal('horas_trabalhadas', 8, 2)->nullable()->comment('Horas trabalhadas (apenas para secundário)');
            $table->decimal('valor_total', 10, 2)->comment('Valor total a pagar');
            $table->enum('status', ['PENDENTE', 'PAGO', 'CANCELADO'])->default('PENDENTE');
            $table->date('data_pagamento')->nullable()->comment('Data em que foi pago');
            $table->text('observacoes')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null')->comment('Usuário que criou o pagamento');
            $table->timestamps();
            
            $table->index(['professor_id', 'mes', 'ano']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('professor_payments');
    }
};
