<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            // Informação Complementar - Irmãos
            $table->integer('num_irmaos_mais_velhos')->nullable()->after('provincia_natural');
            $table->integer('num_irmaos_mais_novos')->nullable()->after('num_irmaos_mais_velhos');
            $table->integer('num_irmaos_mesma_idade')->nullable()->after('num_irmaos_mais_novos');
            
            // Dados do Pai
            $table->string('local_trabalho_pai')->nullable()->after('nome_pai');
            $table->string('endereco_pai_bairro')->nullable()->after('local_trabalho_pai');
            $table->string('endereco_pai_rua')->nullable()->after('endereco_pai_bairro');
            $table->string('endereco_pai_numero')->nullable()->after('endereco_pai_rua');
            $table->string('endereco_pai_quarteirao')->nullable()->after('endereco_pai_numero');
            $table->string('endereco_pai_flat')->nullable()->after('endereco_pai_quarteirao');
            $table->string('telefone_pai')->nullable()->after('endereco_pai_flat');
            $table->string('bi_pai')->nullable()->after('telefone_pai');
            
            // Dados da Mãe
            $table->string('local_trabalho_mae')->nullable()->after('nome_mae');
            $table->string('endereco_mae_bairro')->nullable()->after('local_trabalho_mae');
            $table->string('endereco_mae_rua')->nullable()->after('endereco_mae_bairro');
            $table->string('endereco_mae_numero')->nullable()->after('endereco_mae_rua');
            $table->string('endereco_mae_quarteirao')->nullable()->after('endereco_mae_numero');
            $table->string('endereco_mae_flat')->nullable()->after('endereco_mae_quarteirao');
            $table->string('telefone_mae')->nullable()->after('endereco_mae_flat');
            $table->string('bi_mae')->nullable()->after('telefone_mae');
            
            // Dados de Saúde
            $table->string('plano_saude')->nullable()->after('endereco');
            $table->text('problema_saude_cronico')->nullable()->after('plano_saude');
            $table->text('alergias')->nullable()->after('problema_saude_cronico');
            $table->text('diagnostico_deficiencia')->nullable()->after('alergias');
            $table->text('dificuldade_motora_auditiva_visual_fala_emocional')->nullable()->after('diagnostico_deficiencia');
            $table->text('tratamento_medico')->nullable()->after('dificuldade_motora_auditiva_visual_fala_emocional');
            $table->text('medicacao')->nullable()->after('tratamento_medico');
            $table->boolean('vacinas_em_dia')->nullable()->after('medicacao');
            $table->string('contato_emergencia')->nullable()->after('vacinas_em_dia');
            $table->text('outras_informacoes_saude')->nullable()->after('contato_emergencia');
            
            // Indivíduos Autorizados
            $table->string('individuo_autorizado_1_nome')->nullable()->after('outras_informacoes_saude');
            $table->string('individuo_autorizado_1_telefone')->nullable()->after('individuo_autorizado_1_nome');
            $table->string('individuo_autorizado_2_nome')->nullable()->after('individuo_autorizado_1_telefone');
            $table->string('individuo_autorizado_2_telefone')->nullable()->after('individuo_autorizado_2_nome');
            $table->string('individuo_autorizado_3_nome')->nullable()->after('individuo_autorizado_2_telefone');
            $table->string('individuo_autorizado_3_telefone')->nullable()->after('individuo_autorizado_3_nome');
            
            // Encarregado - campos adicionais
            $table->string('bi_encarregado')->nullable()->after('profissao_encarregado');
            $table->string('grau_parentesco')->nullable()->after('bi_encarregado');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            $table->dropColumn([
                'num_irmaos_mais_velhos',
                'num_irmaos_mais_novos',
                'num_irmaos_mesma_idade',
                'local_trabalho_pai',
                'endereco_pai_bairro',
                'endereco_pai_rua',
                'endereco_pai_numero',
                'endereco_pai_quarteirao',
                'endereco_pai_flat',
                'telefone_pai',
                'bi_pai',
                'local_trabalho_mae',
                'endereco_mae_bairro',
                'endereco_mae_rua',
                'endereco_mae_numero',
                'endereco_mae_quarteirao',
                'endereco_mae_flat',
                'telefone_mae',
                'bi_mae',
                'plano_saude',
                'problema_saude_cronico',
                'alergias',
                'diagnostico_deficiencia',
                'dificuldade_motora_auditiva_visual_fala_emocional',
                'tratamento_medico',
                'medicacao',
                'vacinas_em_dia',
                'contato_emergencia',
                'outras_informacoes_saude',
                'individuo_autorizado_1_nome',
                'individuo_autorizado_1_telefone',
                'individuo_autorizado_2_nome',
                'individuo_autorizado_2_telefone',
                'individuo_autorizado_3_nome',
                'individuo_autorizado_3_telefone',
                'bi_encarregado',
                'grau_parentesco',
            ]);
        });
    }
};
