<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('professor_payments', function (Blueprint $table) {
            $table->decimal('inss', 10, 2)->default(0)->after('valor_total')->comment('Desconto INSS (3% do salário bruto)');
            $table->decimal('irps', 10, 2)->default(0)->after('inss')->comment('Desconto IRPS (Imposto sobre Rendimento)');
            $table->decimal('valor_liquido', 10, 2)->default(0)->after('irps')->comment('Valor líquido (valor_total - inss - irps)');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('professor_payments', function (Blueprint $table) {
            $table->dropColumn(['inss', 'irps', 'valor_liquido']);
        });
    }
};
