<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('funcionario_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('funcionario_id')->constrained('funcionarios')->onDelete('cascade');
            $table->integer('mes')->comment('Mês do pagamento (1-12)');
            $table->integer('ano')->comment('Ano do pagamento');
            $table->decimal('valor_total', 10, 2)->comment('Valor bruto a pagar');
            $table->decimal('inss', 10, 2)->default(0);
            $table->decimal('irps', 10, 2)->default(0);
            $table->decimal('valor_liquido', 10, 2)->default(0);
            $table->enum('status', ['PENDENTE', 'PAGO', 'CANCELADO'])->default('PENDENTE');
            $table->date('data_pagamento')->nullable()->comment('Data em que foi pago');
            $table->text('observacoes')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null')->comment('Usuário que criou o pagamento');
            $table->timestamps();

            $table->index(['funcionario_id', 'mes', 'ano']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('funcionario_payments');
    }
};

