<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('funcionarios_servicos', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('cargo');
            $table->decimal('salario_base', 10, 2)->default(0);
            $table->unsignedInteger('numero_dependentes')->default(0);
            $table->string('telefone')->nullable();
            $table->text('endereco')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            $table->index('cargo');
            $table->index('is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('funcionarios_servicos');
    }
};

