<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    public function run(): void
    {
        $admin = User::firstOrCreate(
            ['email' => 'admin@sge.pt'],
            [
                'name' => 'Administrador',
                'password' => Hash::make('admin123'),
                'tipo' => 'admin',
                'must_change_password' => false,
                'is_active' => true,
            ]
        );

        $role = Role::where('slug', 'admin')->first();
        if ($role && !$admin->hasRole($role)) {
            $admin->roles()->attach($role);
        }
    }
}

