<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Aluno;
use App\Services\CodigoEstudanteService;
use Illuminate\Support\Facades\Hash;

class AlunoSeeder extends Seeder
{
    public function run(): void
    {
        $nomes = [
            'João Silva', 'Maria Santos', 'Pedro Costa', 'Ana Oliveira', 'Carlos Mendes',
            'Sofia Pereira', 'Miguel Fernandes', 'Beatriz Rodrigues', 'Tiago Alves', 'Inês Martins',
            'Rafael Sousa', 'Mariana Ferreira', 'Gonçalo Gomes', 'Carolina Lopes', 'Diogo Ribeiro',
            'Leonor Carvalho', 'Francisco Pinto', 'Matilde Correia', 'Tomás Nunes', 'Lara Moreira'
        ];

        $anoAtual = date('Y');
        $anoIngresso = $anoAtual; // Pode variar se quiser alunos de anos diferentes

        foreach ($nomes as $index => $nome) {
            // Criar usuário
            $email = strtolower(str_replace(' ', '', $nome)) . '@aluno.sge.pt';
            
            $user = User::firstOrCreate(
                ['email' => $email],
                [
                    'name' => $nome,
                    'password' => Hash::make($anoAtual),
                    'tipo' => 'aluno',
                    'must_change_password' => true,
                    'is_active' => true,
                ]
            );

            // Criar aluno se não existir
            if (!$user->aluno) {
                $codigoEstudante = CodigoEstudanteService::gerar($anoIngresso);
                
                Aluno::create([
                    'user_id' => $user->id,
                    'codigo_estudante' => $codigoEstudante,
                    'telefone' => '+258 8' . rand(1000000, 9999999),
                    'endereco' => 'Endereço ' . ($index + 1) . ', Maputo',
                    'data_nascimento' => now()->subYears(rand(10, 18))->subDays(rand(0, 365)),
                    'genero' => ['M', 'F'][rand(0, 1)],
                    'nome_encarregado' => 'Encarregado de ' . $nome,
                    'telefone_encarregado' => '+258 8' . rand(1000000, 9999999),
                ]);
            }
        }
    }
}
