<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Aluno;
use App\Models\Professor;
use App\Models\User;
use App\Models\Financeiro;
use App\Models\Payment;
use App\Models\Invoice;
use App\Models\Avaliacao;
use App\Models\TurmaAluno;
use Illuminate\Support\Facades\DB;

class ApagarAlunosEProfessoresSeeder extends Seeder
{
    public function run(): void
    {
        $this->command->info('=== APAGANDO TODOS OS ALUNOS E PROFESSORES ===');
        
        // Desabilitar verificação de foreign keys temporariamente
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        
        try {
            // 1. Apagar registros relacionados aos alunos
            $this->command->info('Apagando registros financeiros relacionados aos alunos...');
            Financeiro::query()->delete();
            
            $this->command->info('Apagando pagamentos...');
            Payment::query()->delete();
            
            $this->command->info('Apagando facturas...');
            Invoice::query()->delete();
            
            $this->command->info('Apagando avaliações...');
            Avaliacao::query()->delete();
            
            $this->command->info('Apagando relações turma-aluno...');
            DB::table('turma_aluno')->delete();
            
            // 2. Apagar alunos e seus usuários
            $this->command->info('Apagando alunos...');
            $alunos = Aluno::all();
            $alunoUserIds = $alunos->pluck('user_id')->filter();
            
            if ($alunos->count() > 0) {
                $this->command->info("Encontrados {$alunos->count()} alunos");
                Aluno::query()->delete();
                
                // Apagar usuários dos alunos
                if ($alunoUserIds->count() > 0) {
                    $this->command->info('Apagando usuários dos alunos...');
                    User::whereIn('id', $alunoUserIds)->delete();
                }
            } else {
                $this->command->info('Nenhum aluno encontrado');
            }
            
            // 3. Apagar professores e seus usuários
            $this->command->info('Apagando professores...');
            $professores = Professor::all();
            $professorUserIds = $professores->pluck('user_id')->filter();
            
            if ($professores->count() > 0) {
                $this->command->info("Encontrados {$professores->count()} professores");
                
                // Apagar relações turma-disciplina-professor
                $this->command->info('Apagando relações turma-disciplina-professor...');
                DB::table('turma_disciplina_professor')->delete();
                
                Professor::query()->delete();
                
                // Apagar usuários dos professores
                if ($professorUserIds->count() > 0) {
                    $this->command->info('Apagando usuários dos professores...');
                    User::whereIn('id', $professorUserIds)->delete();
                }
            } else {
                $this->command->info('Nenhum professor encontrado');
            }
            
            // Reabilitar verificação de foreign keys
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
            
            $this->command->info('=== CONCLUÍDO ===');
            $this->command->info('Todos os alunos e professores foram apagados com sucesso!');
            
        } catch (\Exception $e) {
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
            $this->command->error('Erro ao apagar: ' . $e->getMessage());
            throw $e;
        }
    }
}
