<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Professor;
use Illuminate\Support\Facades\Hash;

class ProfessorSeeder extends Seeder
{
    public function run(): void
    {
        $nomes = [
            'António Machado', 'Isabel Ferreira', 'Manuel Santos', 'Cristina Oliveira', 'José Silva',
            'Patrícia Costa', 'Ricardo Mendes', 'Sandra Pereira', 'Paulo Fernandes', 'Teresa Rodrigues',
            'Luís Alves', 'Mónica Martins', 'Nuno Sousa', 'Rita Ferreira', 'Hugo Gomes',
            'Carla Lopes', 'Bruno Ribeiro', 'Diana Carvalho', 'Filipe Pinto', 'Eva Correia'
        ];

        $anoAtual = date('Y');

        foreach ($nomes as $index => $nome) {
            // Criar usuário
            $email = strtolower(str_replace(' ', '', $nome)) . '@professor.sge.pt';
            
            $user = User::firstOrCreate(
                ['email' => $email],
                [
                    'name' => $nome,
                    'password' => Hash::make($anoAtual),
                    'tipo' => 'professor',
                    'must_change_password' => true,
                    'is_active' => true,
                ]
            );

            // Criar professor se não existir
            if (!$user->professor) {
                Professor::create([
                    'user_id' => $user->id,
                    'numero_funcionario' => 'PROF' . str_pad($index + 1, 4, '0', STR_PAD_LEFT),
                    'telefone' => '+258 8' . rand(1000000, 9999999),
                    'endereco' => 'Endereço ' . ($index + 1) . ', Maputo',
                    'data_nascimento' => now()->subYears(rand(25, 55))->subDays(rand(0, 365)),
                    'genero' => ['M', 'F'][rand(0, 1)],
                ]);
            }
        }
    }
}
