<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Turma;
use App\Models\AnoLetivo;
use Illuminate\Support\Facades\DB;

class ReduzirAlunosPorTurmaSeeder extends Seeder
{
    public function run(): void
    {
        $this->command->info('=== REDUZINDO ALUNOS POR TURMA ATÉ O LIMITE DE 35 ===');
        
        $anoLetivo = AnoLetivo::getAnoLetivoAtual();
        
        if (!$anoLetivo) {
            $this->command->error('Ano letivo atual não encontrado!');
            return;
        }
        
        $this->command->info("Usando ano letivo: {$anoLetivo->ano} (ID: {$anoLetivo->id})");
        
        // Buscar todas as turmas do ano letivo atual
        $turmas = Turma::where('ano_letivo_id', $anoLetivo->id)
            ->where('ativa', true)
            ->get();
        
        $totalRemovidos = 0;
        $turmasAjustadas = 0;
        
        foreach ($turmas as $turma) {
            $capacidadeMaxima = $turma->capacidade_maxima ?? 35;
            
            // Contar alunos na turma
            $alunosNaTurma = DB::table('turma_aluno')
                ->where('turma_id', $turma->id)
                ->where('ano_letivo_id', $anoLetivo->id)
                ->count();
            
            if ($alunosNaTurma > $capacidadeMaxima) {
                $excesso = $alunosNaTurma - $capacidadeMaxima;
                
                $this->command->info("Turma {$turma->codigo} - {$turma->nome}: {$alunosNaTurma} alunos (excesso: {$excesso})");
                
                // Buscar IDs dos alunos para remover (os últimos adicionados)
                $alunosParaRemover = DB::table('turma_aluno')
                    ->where('turma_id', $turma->id)
                    ->where('ano_letivo_id', $anoLetivo->id)
                    ->orderBy('created_at', 'desc') // Remove os últimos adicionados
                    ->limit($excesso)
                    ->pluck('aluno_id');
                
                // Remover os alunos excedentes
                foreach ($alunosParaRemover as $alunoId) {
                    DB::table('turma_aluno')
                        ->where('turma_id', $turma->id)
                        ->where('aluno_id', $alunoId)
                        ->where('ano_letivo_id', $anoLetivo->id)
                        ->delete();
                    
                    $totalRemovidos++;
                }
                
                $this->command->info("  → Removidos {$excesso} aluno(s). Restam {$capacidadeMaxima} alunos.");
                $turmasAjustadas++;
            } else {
                $this->command->info("Turma {$turma->codigo} - {$turma->nome}: {$alunosNaTurma} alunos (OK)");
            }
        }
        
        $this->command->info('');
        $this->command->info("=== CONCLUÍDO ===");
        $this->command->info("Turmas ajustadas: {$turmasAjustadas}");
        $this->command->info("Total de alunos removidos: {$totalRemovidos}");
    }
}
