<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    public function run(): void
    {
        // Permissões
        $permissions = [
            ['name' => 'Registar Alunos', 'slug' => 'registar_alunos', 'description' => 'Permite registar novos alunos'],
            ['name' => 'Registar Professores', 'slug' => 'registar_professores', 'description' => 'Permite registar novos professores'],
            ['name' => 'Gestão Financeira', 'slug' => 'gestao_financeira', 'description' => 'Permite gerir finanças'],
            ['name' => 'Gestão de Horários', 'slug' => 'gestao_horarios', 'description' => 'Permite gerir horários'],
            ['name' => 'Gestão de Eventos', 'slug' => 'gestao_eventos', 'description' => 'Permite gerir eventos'],
            ['name' => 'Alocação de Professores', 'slug' => 'alocacao_professores', 'description' => 'Permite alocar professores'],
            ['name' => 'Alocação de Alunos', 'slug' => 'alocacao_alunos', 'description' => 'Permite alocar alunos'],
        ];

        foreach ($permissions as $permission) {
            Permission::create($permission);
        }

        // Roles
        $roles = [
            ['name' => 'Superadmin', 'slug' => 'superadmin', 'description' => 'Acesso total ao sistema'],
            ['name' => 'Admin', 'slug' => 'admin', 'description' => 'Administrador do sistema'],
            ['name' => 'Funcionário', 'slug' => 'funcionario', 'description' => 'Funcionário com permissões específicas'],
            ['name' => 'Professor', 'slug' => 'professor', 'description' => 'Professor'],
            ['name' => 'Aluno', 'slug' => 'aluno', 'description' => 'Aluno'],
        ];

        foreach ($roles as $role) {
            Role::create($role);
        }
    }
}



