@extends('layouts.app')

@section('title', 'Alocar Aluno - SIGE')

@section('content')
<div class="row">
    <div class="col-md-6 mx-auto">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Alocar Aluno a Turma</h5>
            <a href="{{ route('admin.alunos.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="card">
            <div class="card-body">
                <div class="mb-3 text-muted small">
                    <strong>{{ $aluno->codigo_estudante ?? 'N/A' }}</strong> - {{ $aluno->user->name }}
                    @if($turmaAtual)
                        <span class="badge bg-secondary ms-2">{{ $turmaAtual->codigo }} - {{ $turmaAtual->nome }}</span>
                    @endif
                </div>

                <form method="POST" action="{{ route('admin.alunos.alocar.store', $aluno) }}">
                    @csrf
                    
                    <div class="mb-3">
                        <label for="ano_letivo_id" class="form-label">Ano Lectivo <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('ano_letivo_id') is-invalid @enderror" 
                                id="ano_letivo_id" name="ano_letivo_id" required>
                            <option value="">Selecione o Ano Lectivo</option>
                            @foreach($anosLetivos as $ano)
                                <option value="{{ $ano->id }}" {{ ($anoLetivo && $anoLetivo->id == $ano->id) ? 'selected' : '' }}>
                                    @php
                                        $anoFinal = strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[1] : $ano->ano;
                                    @endphp
                                    {{ $anoFinal }}
                                    @if($ano->ativo) (Activo) @endif
                                </option>
                            @endforeach
                        </select>
                        @error('ano_letivo_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="turma_id" class="form-label">Turma <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('turma_id') is-invalid @enderror" 
                                id="turma_id" name="turma_id" required {{ !$anoLetivo ? 'disabled' : '' }}>
                            <option value="">{{ $anoLetivo ? 'Selecione a Turma' : 'Selecione o Ano Lectivo primeiro' }}</option>
                            @if($anoLetivo && $turmas->count() > 0)
                                @foreach($turmas as $turma)
                                    <option value="{{ $turma->id }}" {{ old('turma_id') == $turma->id ? 'selected' : '' }}>
                                        {{ $turma->codigo }} - {{ $turma->nome }}
                                    </option>
                                @endforeach
                            @endif
                        </select>
                        @error('turma_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="bi bi-check-circle"></i> Confirmar
                        </button>
                        <a href="{{ route('admin.alunos.index') }}" class="btn btn-secondary btn-sm">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Atualizar turmas quando o ano letivo mudar
    document.getElementById('ano_letivo_id').addEventListener('change', function() {
        const anoLetivoId = this.value;
        const turmaSelect = document.getElementById('turma_id');
        
        if (anoLetivoId) {
            // Recarregar a página com o ano letivo selecionado para carregar as turmas
            const url = new URL(window.location.href);
            url.searchParams.set('ano_letivo_id', anoLetivoId);
            window.location.href = url.toString();
        } else {
            turmaSelect.innerHTML = '<option value="">Selecione o Ano Lectivo primeiro</option>';
            turmaSelect.disabled = true;
        }
    });
</script>
@endsection

