@extends('layouts.app')

@section('title', 'Cartões de Estudantes - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 10px;">
            <h5 class="mb-0" style="font-weight: 600;">Cartões de Estudantes</h5>
            <a href="{{ route('admin.alunos.index') }}" class="btn btn-sm btn-outline-secondary">Voltar aos Alunos</a>
        </div>

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Fechar"></button>
            </div>
        @endif

        <form method="GET" action="{{ route('admin.cartoes-estudantes.index') }}" id="form-filtros" class="mb-3 p-3 rounded" style="background: #f8f9fa;">
            <div class="row g-2 align-items-end flex-wrap">
                <div class="col-auto">
                    <label class="form-label small mb-0">Ano lectivo</label>
                    <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id" style="width: 140px;">
                        @foreach($anosLetivos ?? [] as $ano)
                            <option value="{{ $ano->id }}" {{ ($anoLetivoId ?? null) == $ano->id ? 'selected' : '' }}>
                                {{ is_string($ano->ano) && strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[0] : $ano->ano }}
                                @if($ano->ativo) (activo) @endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-auto">
                    <label class="form-label small mb-0">Classe</label>
                    <select class="form-select form-select-sm" id="classe" name="classe" style="width: 130px;">
                        <option value="">Todas</option>
                        @foreach($classes ?? [] as $c)
                            <option value="{{ $c }}" {{ request('classe') == $c ? 'selected' : '' }}>{{ $c }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-auto">
                    <label class="form-label small mb-0">Turma</label>
                    <select class="form-select form-select-sm" id="turma" name="turma" style="width: 120px;">
                        <option value="">Todas</option>
                        @foreach($turmas ?? [] as $t)
                            <option value="{{ $t }}" {{ request('turma') == $t ? 'selected' : '' }}>{{ $t }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-auto">
                    <label class="form-label small mb-0">Pesquisar</label>
                    <input type="text" class="form-control form-control-sm" id="search" name="search" value="{{ request('search') }}" placeholder="Código ou nome..." style="width: 180px;">
                </div>
                <div class="col-auto">
                    <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
                    @if(request('search') || request('classe') || request('turma') || request('ano_letivo_id'))
                        <a href="{{ route('admin.cartoes-estudantes.index') }}" class="btn btn-sm btn-secondary">Limpar</a>
                    @endif
                </div>
            </div>
        </form>

        <div class="mb-3 d-flex flex-wrap gap-2 align-items-center">
            <span class="me-2 small text-muted">Gerar cartões:</span>
            <button type="button" class="btn btn-sm btn-outline-primary" id="btn-imprimir-todos">Imprimir todos (filtrados)</button>
            <span class="mx-2">|</span>
            <button type="button" class="btn btn-sm btn-primary" id="btn-imprimir-sel">Imprimir selecionados</button>
            <label class="ms-2 mb-0 small">
                <input type="checkbox" id="check-all" class="form-check-input"> Selecionar todos nesta página
            </label>
        </div>

        <div class="table-responsive">
            <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="width: 40px; padding: 8px;"></th>
                        <th style="padding: 8px;">Código</th>
                        <th style="padding: 8px;">Nome</th>
                        <th style="padding: 8px;">Classe / Turma</th>
                        <th style="padding: 8px;">Acções</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($alunos as $aluno)
                        <tr>
                            <td style="padding: 8px; vertical-align: middle;">
                                <input type="checkbox" class="form-check-input cartao-id" value="{{ $aluno->id }}" data-id="{{ $aluno->id }}">
                            </td>
                            <td style="padding: 8px;">{{ $aluno->codigo_estudante }}</td>
                            <td style="padding: 8px;">{{ $aluno->user->name ?? '-' }}</td>
                            <td style="padding: 8px;">
                                @if($aluno->turmas->count() > 0)
                                    @foreach($aluno->turmas as $turma)
                                        <span class="badge bg-light text-dark border">{{ $turma->codigo }} - {{ $turma->nome }}</span>
                                    @endforeach
                                @else
                                    <span class="text-muted">—</span>
                                @endif
                            </td>
                            <td style="padding: 8px;">
                                <div class="d-flex gap-1">
                                    <button type="button" class="btn btn-sm btn-outline-primary btn-ver-cartao" data-url="{{ route('admin.alunos.imprimir-cartao', $aluno) }}" data-nome="{{ $aluno->user->name ?? $aluno->codigo_estudante }}" title="Ver cartão">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                    <a href="{{ route('admin.alunos.imprimir-cartao', $aluno) }}" class="btn btn-sm btn-outline-secondary" target="_blank" title="Imprimir cartão individual">
                                        <i class="bi bi-printer"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-4 text-muted">Nenhum estudante encontrado. Ajuste os filtros.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if(method_exists($alunos, 'links'))
            <div class="mt-3">
                {{ $alunos->appends(request()->query())->links() }}
            </div>
        @endif
    </div>
</div>

<div class="modal fade" id="modalVerCartao" tabindex="-1" aria-labelledby="modalVerCartaoLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalVerCartaoLabel">Cartão de Estudante</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
            </div>
            <div class="modal-body p-0 bg-light" style="min-height: 60vh;">
                <iframe id="iframeCartao" src="" style="width: 100%; height: 70vh; border: none;" title="Cartão"></iframe>
            </div>
            <div class="modal-footer">
                <a id="btnImprimirCartaoModal" href="#" target="_blank" class="btn btn-primary">
                    <i class="bi bi-printer me-1"></i> Abrir para imprimir
                </a>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<script>
(function() {
    const baseImprimir = '{{ route("admin.cartoes-estudantes.imprimir") }}';
    const baseFiltros = '{{ route("admin.cartoes-estudantes.filtros") }}';

    function queryString(obj) {
        const p = new URLSearchParams();
        Object.keys(obj).forEach(k => {
            const v = obj[k];
            if (v === undefined || v === '') return;
            if (Array.isArray(v)) v.forEach(x => p.append(k + '[]', x));
            else p.set(k, v);
        });
        return p.toString();
    }

    function filtrosAtuais() {
        return {
            ano_letivo_id: document.getElementById('ano_letivo_id')?.value || '',
            classe: document.getElementById('classe')?.value || '',
            turma: document.getElementById('turma')?.value || '',
            search: document.getElementById('search')?.value || ''
        };
    }

    function idsSelecionados() {
        return Array.from(document.querySelectorAll('.cartao-id:checked')).map(c => c.value);
    }

    document.getElementById('check-all')?.addEventListener('change', function() {
        document.querySelectorAll('.cartao-id').forEach(c => { c.checked = this.checked; });
    });

    document.getElementById('btn-imprimir-todos')?.addEventListener('click', function() {
        const q = queryString(filtrosAtuais());
        window.open(baseImprimir + (q ? '?' + q : ''), '_blank', 'noopener');
    });

    document.getElementById('btn-imprimir-sel')?.addEventListener('click', function() {
        const ids = idsSelecionados();
        if (!ids.length) { alert('Selecione pelo menos um estudante.'); return; }
        window.open(baseImprimir + '?' + queryString({ ids: ids }), '_blank', 'noopener');
    });

    document.getElementById('ano_letivo_id')?.addEventListener('change', function() {
        const id = this.value;
        fetch(baseFiltros + '?ano_letivo_id=' + encodeURIComponent(id), {
            headers: { 'Accept': 'application/json', 'X-Requested-With': 'XMLHttpRequest' }
        })
        .then(r => r.json())
        .then(data => {
            const c = document.getElementById('classe');
            const t = document.getElementById('turma');
            const vc = c.value, vt = t.value;
            c.innerHTML = '<option value="">Todas</option>' + (data.classes || []).map(x => '<option value="' + x + '">' + x + '</option>').join('');
            t.innerHTML = '<option value="">Todas</option>' + (data.turmas || []).map(x => '<option value="' + x + '">' + x + '</option>').join('');
            if (vc) c.value = vc;
            if (vt) t.value = vt;
        })
        .catch(() => {});
    });

    var modalEl = document.getElementById('modalVerCartao');
    var iframe = document.getElementById('iframeCartao');
    var modalTitle = document.getElementById('modalVerCartaoLabel');
    var btnImprimir = document.getElementById('btnImprimirCartaoModal');
    var modalInstance = null;

    function initModal() {
        if (!modalEl) return;
        if (modalEl.parentNode !== document.body) {
            document.body.appendChild(modalEl);
        }
        if (modalInstance) return;
        if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
            modalInstance = new bootstrap.Modal(modalEl);
            modalEl.addEventListener('hidden.bs.modal', function() { if (iframe) iframe.src = 'about:blank'; });
        }
    }

    function showCartao(url, nome) {
        if (!url) return;
        initModal();
        if (modalTitle) modalTitle.textContent = 'Cartão de Estudante – ' + (nome || 'Cartão');
        if (iframe) iframe.src = url;
        if (btnImprimir) btnImprimir.href = url;
        if (modalInstance) {
            modalInstance.show();
        } else {
            window.open(url, '_blank', 'noopener');
        }
    }

    document.querySelectorAll('.btn-ver-cartao').forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            showCartao(this.getAttribute('data-url'), this.getAttribute('data-nome'));
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(initModal, 600);
    });
})();
</script>
@endsection
