@extends('layouts.app')

@section('title', 'Alunos Inscritos - SIGE')

@section('content')
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Alunos Inscritos por Ano Letivo</h5>
        <a href="{{ route('admin.alunos.index') }}" class="btn btn-sm btn-secondary">
            <i class="bi bi-arrow-left"></i> Voltar
        </a>
    </div>

    <div class="js-ajax-pagination">
        <div class="card mb-3">
            <div class="card-body p-2">
                <form method="GET" action="{{ route('admin.alunos.inscritos') }}" class="row g-2">
                <div class="col-md-4">
                    <label for="ano_letivo_id" class="form-label small mb-0">Ano Letivo</label>
                    <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id" onchange="this.form.submit()">
                        <option value="">Todos os Anos Letivos</option>
                        @foreach($anosLetivos as $ano)
                            <option value="{{ $ano->id }}" {{ $anoLetivoId == $ano->id ? 'selected' : '' }}>
                                {{ $ano->ano }}
                                @if($ano->ativo) (Activo) @endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="turma_id" class="form-label small mb-0">Turma</label>
                    <select class="form-select form-select-sm" id="turma_id" name="turma_id">
                        <option value="">Todas as Turmas</option>
                        @foreach($turmas as $turma)
                            <option value="{{ $turma->id }}" {{ request('turma_id') == $turma->id ? 'selected' : '' }}>
                                {{ $turma->codigo }} - {{ $turma->nome }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="search" class="form-label small mb-0">Pesquisar</label>
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ request('search') }}" placeholder="Código ou Nome">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-search"></i>
                        </button>
                    </div>
                </div>
                </form>
            </div>
        </div>

        @if($anoLetivoSelecionado)
            <div class="alert alert-info py-2 mb-3">
                <strong>Ano Letivo:</strong> {{ $anoLetivoSelecionado->ano }} | 
                <strong>Total de Alunos:</strong> {{ $alunos->total() }}
            </div>
        @endif

        <div class="card">
            <div class="card-body p-2">
                @if($alunos->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Código</th>
                                <th>Nome</th>
                                <th>Género</th>
                                <th>Turma(s)</th>
                                <th>Situação Financeira</th>
                                <th>Acções</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($alunos as $aluno)
                                @php
                                    $turmasAluno = $aluno->turmas->pluck('codigo')->join(', ');
                                    $financeiroService = app(\App\Services\FinanceiroService::class);
                                    $situacaoFinanceira = $financeiroService->getSituacaoFinanceira(
                                        $aluno, 
                                        $anoLetivoId
                                    );
                                @endphp
                                <tr>
                                    <td>{{ $aluno->codigo_estudante ?? 'N/A' }}</td>
                                    <td>{{ $aluno->user->name }}</td>
                                    <td>
                                        @if($aluno->genero == 'M') Masculino
                                        @elseif($aluno->genero == 'F') Feminino
                                        @else Outro
                                        @endif
                                    </td>
                                    <td>{{ $turmasAluno ?: 'N/A' }}</td>
                                    <td>
                                        @if($situacaoFinanceira == 'EM_DÍVIDA')
                                            <span class="badge bg-danger">Em Dívida</span>
                                        @else
                                            <span class="badge bg-success">Regular</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.alunos.show', $aluno) }}" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-eye"></i> Ver
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        </table>
                    </div>
                    
                    @if(method_exists($alunos, 'links'))
                        <div class="mt-3">
                            {{ $alunos->appends(request()->query())->links() }}
                        </div>
                    @endif
                @else
                    <div class="alert alert-info">
                        Nenhum aluno encontrado para os filtros selecionados.
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

