@extends('layouts.app')

@section('title', 'Alunos com Múltiplas Turmas - SIGE')

@section('content')
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Alunos com Mais de 2 Turmas/Classes</h5>
        <a href="{{ route('admin.alunos.index') }}" class="btn btn-sm btn-outline-primary">Voltar</a>
    </div>

    <div class="alert alert-info">
        <i class="bi bi-info-circle"></i> 
        <strong>Informação:</strong> Estes alunos estão alocados a mais de 2 turmas ou classes. Esta visualização ajuda a identificar alunos com múltiplas alocações.
    </div>

    <div class="card mb-3">
        <div class="card-body p-2">
            <form method="GET" action="{{ route('admin.alunos.multiplas-turmas') }}" class="row g-2">
                <div class="col-md-3">
                    <label for="ano_letivo_id" class="form-label small mb-0">Ano Lectivo</label>
                    <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id">
                        <option value="">Todos os Anos</option>
                        @foreach($anosLetivos as $ano)
                            <option value="{{ $ano->id }}" {{ $anoLetivoId == $ano->id ? 'selected' : '' }}>
                                @php
                                    $anoFinal = strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[1] : $ano->ano;
                                @endphp
                                {{ $anoFinal }}
                                @if($ano->ativo) (Activo) @endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="search" class="form-label small mb-0">Pesquisar</label>
                    <input type="text" class="form-control form-control-sm" id="search" name="search" 
                           value="{{ request('search') }}" placeholder="Código ou Nome...">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-sm btn-primary mt-4">Filtrar</button>
                </div>
            </form>
        </div>
    </div>

    @if($anoLetivoSelecionado)
        @php
            $anoFinal = strpos($anoLetivoSelecionado->ano, '/') !== false ? explode('/', $anoLetivoSelecionado->ano)[1] : $anoLetivoSelecionado->ano;
        @endphp
        <div class="alert alert-info py-2 mb-3">
            <strong>Ano Lectivo:</strong> {{ $anoFinal }} | 
            <strong>Total de Alunos com Múltiplas Turmas:</strong> {{ $alunosMultiplasTurmas->count() }}
        </div>
    @endif

    <div class="table-responsive">
        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
            <thead style="background-color: #f8f9fa;">
                <tr>
                    <th style="padding: 6px;">Código</th>
                    <th style="padding: 6px;">Nome</th>
                    <th style="padding: 6px;">Total Turmas</th>
                    <th style="padding: 6px;">Total Classes</th>
                    <th style="padding: 6px;">Turmas/Classes</th>
                    <th style="padding: 6px;">Status</th>
                    <th style="padding: 6px;">Acções</th>
                </tr>
            </thead>
            <tbody>
                @forelse($alunosMultiplasTurmas as $aluno)
                    <tr style="background-color: {{ $aluno->total_turmas > 3 ? '#fff3cd' : '#ffffff' }};">
                        <td style="padding: 5px;">{{ $aluno->codigo_estudante }}</td>
                        <td style="padding: 5px;">{{ $aluno->user->name ?? '-' }}</td>
                        <td style="padding: 5px; text-align: center;">
                            <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px; font-weight: bold;">
                                {{ $aluno->total_turmas }}
                            </span>
                        </td>
                        <td style="padding: 5px; text-align: center;">
                            <span style="font-size: 0.75rem; padding: 2px 6px; background: #fff3cd; color: #856404; border-radius: 3px; font-weight: bold;">
                                {{ $aluno->total_classes }}
                            </span>
                        </td>
                        <td style="padding: 5px;">
                            @foreach($aluno->turmas_por_classe as $codigoClasse => $turmas)
                                <div style="margin-bottom: 4px;">
                                    <strong style="font-size: 0.7rem; color: #856404;">{{ $codigoClasse }}:</strong>
                                    @foreach($turmas as $turma)
                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px; margin-right: 2px;">
                                            {{ $turma->nome }}
                                        </span>
                                    @endforeach
                                </div>
                            @endforeach
                        </td>
                        <td style="padding: 5px;">
                            @if($aluno->user && $aluno->user->is_active)
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activo</span>
                            @else
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Bloqueado</span>
                            @endif
                        </td>
                        <td style="padding: 5px;">
                            <div style="display: flex; gap: 4px;">
                                <a href="{{ route('admin.alunos.show', $aluno) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #e7f3ff; color: #0066cc; border: none;" title="Visualizar">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="{{ route('admin.alunos.edit', $aluno) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center">
                            @if($anoLetivoSelecionado)
                                Nenhum aluno com mais de 2 turmas encontrado para o ano letivo selecionado.
                            @else
                                Selecione um ano letivo para ver os alunos com múltiplas turmas.
                            @endif
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection

