@php
    $turmaAtual = null;
    $classe = 'N/A';
    if ($anoLetivo && $aluno->turmas && $aluno->turmas->isNotEmpty()) {
        $turmaAtual = $aluno->turmas->first();
        $classe = $turmaAtual && isset($turmaAtual->codigo) ? $turmaAtual->codigo : 'N/A';
    }
@endphp
<div class="cartao-container">
    <svg class="decoracao-canto-inferior" viewBox="0 0 120 120" preserveAspectRatio="none">
        <path class="forma-azul-claro" d="M 120,120 C 110,115 100,105 95,90 C 90,75 85,65 80,55 L 120,55 Z" />
        <path class="linha-dourada" d="M 120,108 C 112,102 105,92 100,80 C 95,70 90,62 85,58" />
        <circle class="detalhe-dourado" cx="95" cy="95" r="4" />
    </svg>
    <div class="header-section">
        <div class="logo-container">
            @php
                $logotipoUrl = isset($logotipoBase64) && $logotipoBase64 
                    ? $logotipoBase64 
                    : ($configuracao['logotipo'] ? asset('storage/' . $configuracao['logotipo']) : null);
            @endphp
            @if($logotipoUrl)
                <img src="{{ $logotipoUrl }}" alt="Logo" class="logo-icon" style="max-width: 38mm; max-height: 38mm; object-fit: contain;">
            @else
                <svg class="logo-icon" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                    <path d="M 15,75 L 15,90 L 85,90 L 85,75 Z" fill="{{ $configuracao['cor_principal'] }}" stroke="{{ $configuracao['cor_principal'] }}" stroke-width="1"/>
                    <path d="M 15,75 L 50,70 L 85,75" stroke="{{ $configuracao['cor_destaque'] }}" stroke-width="2" fill="none"/>
                    <path d="M 20,75 L 20,88 L 45,88 L 45,75" fill="#ffffff" opacity="0.3"/>
                    <path d="M 55,75 L 55,88 L 80,88 L 80,75" fill="#ffffff" opacity="0.3"/>
                    <ellipse cx="50" cy="55" rx="12" ry="18" fill="{{ $configuracao['cor_destaque'] }}"/>
                    <circle cx="50" cy="35" r="10" fill="{{ $configuracao['cor_destaque'] }}"/>
                    <path d="M 40,28 L 50,22 L 60,28 L 58,32 L 42,32 Z" fill="{{ $configuracao['cor_principal'] }}"/>
                    <circle cx="50" cy="22" r="3" fill="{{ $configuracao['cor_destaque'] }}"/>
                    <path d="M 38,50 Q 30,45 28,40" stroke="{{ $configuracao['cor_destaque'] }}" stroke-width="3" fill="none" stroke-linecap="round"/>
                    <path d="M 62,50 Q 70,45 72,40" stroke="{{ $configuracao['cor_destaque'] }}" stroke-width="3" fill="none" stroke-linecap="round"/>
                </svg>
            @endif
            <div class="escola-nome">{{ $configuracao['escola'] }}</div>
            @if(!empty($configuracao['slogan']))
                <div class="escola-slogan">{{ $configuracao['slogan'] }}</div>
            @endif
        </div>
    </div>
    <div class="foto-section">
        @php
            $fotoUrl = isset($aluno->foto_base64) && $aluno->foto_base64 
                ? $aluno->foto_base64 
                : ($aluno->foto ? asset('storage/' . $aluno->foto) : null);
        @endphp
        @if($fotoUrl)
            <img src="{{ $fotoUrl }}" alt="Foto">
        @else
            <div class="foto-placeholder">Sem<br>Foto</div>
        @endif
    </div>
    <div class="faixa-inferior">
        <div class="onda-fundo">
            <svg viewBox="0 0 100 20" preserveAspectRatio="none">
                <path class="onda-principal" d="M 0,8 Q 12,2 25,6 T 50,4 T 75,8 T 100,3 L 100,20 L 0,20 Z" />
                <path class="onda-secundaria" d="M 0,12 Q 15,5 30,10 T 55,6 T 80,11 T 100,6 L 100,20 L 0,20 Z" opacity="0.6" />
                <path class="onda-destaque" d="M 0,10 Q 12,3 25,8 T 50,5 T 75,9 T 100,4" />
            </svg>
        </div>
        <div class="faixa-content">
            <div class="faixa-nome">{{ $aluno->user?->name ?? $aluno->codigo_estudante ?? '' }}</div>
            <div class="faixa-info-container">
                <div class="info-card"><span class="info-card-label">CLASSE:</span><span class="info-card-value">{{ $classe }}</span></div>
                <div class="info-card"><span class="info-card-label">TURMA:</span><span class="info-card-value">{{ $turmaAtual ? $turmaAtual->nome : 'N/A' }}</span></div>
            </div>
            <div class="faixa-codigo">CÓDIGO DO ESTUDANTE: {{ $aluno->codigo_estudante }}</div>
        </div>
    </div>
</div>
<div class="cartao-verso">
    <svg class="verso-onda-sup-esq" viewBox="0 0 100 100" preserveAspectRatio="none">
        <path fill="{{ $configuracao['cor_principal'] }}" d="M 0,0 Q 20,15 35,35 T 60,55 L 0,55 Z" />
        <path fill="{{ $configuracao['cor_principal'] }}" opacity="0.6" d="M 0,5 Q 15,25 30,45 T 55,50 L 0,50 Z" />
        <path fill="none" stroke="{{ $configuracao['cor_destaque'] }}" stroke-width="2" d="M 0,18 Q 18,32 32,48 T 58,52" />
    </svg>
    <svg class="verso-onda-inf-dir" viewBox="0 0 100 100" preserveAspectRatio="none">
        <path fill="{{ $configuracao['cor_destaque'] }}" d="M 100,100 Q 80,85 65,65 T 45,35 L 100,35 Z" />
        <path fill="{{ $configuracao['cor_destaque'] }}" opacity="0.6" d="M 100,95 Q 82,78 68,58 T 48,38 L 100,38 Z" />
        <path fill="none" stroke="{{ $configuracao['cor_principal'] }}" stroke-width="2" d="M 100,82 Q 85,65 72,48 T 52,40" />
    </svg>
    <svg class="verso-onda-meio" viewBox="0 0 100 20" preserveAspectRatio="none">
        <path fill="{{ $configuracao['cor_secundaria'] }}" d="M 0,12 Q 20,2 50,10 T 100,6 L 100,20 L 0,20 Z" />
    </svg>
    <div class="verso-qr">
        @php
            $qrUrl = isset($aluno->qr_code_base64) && $aluno->qr_code_base64 
                ? $aluno->qr_code_base64 
                : 'https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=' . urlencode($aluno->codigo_estudante);
        @endphp
        <img src="{{ $qrUrl }}" alt="QR" width="80" height="80" style="display: block; width: 100%; height: 100%; object-fit: contain;">
    </div>
    <div class="verso-texto">
        <div class="verso-ano">ANO LECTIVO: {{ $configuracao['ano_lectivo'] }}</div>
        <div class="verso-validade">VALIDADE: {{ $configuracao['validade'] }}</div>
    </div>
    <div class="verso-aviso">Este cartão é pessoal e intransferível. Em caso de perda, contacte a secretaria académica.</div>
    <div class="verso-contacto">CONTACTO: {{ $configuracao['contacto'] }} | {{ $configuracao['website'] }}</div>
</div>
