@extends('layouts.app')

@section('title', 'Renovação de Matrícula - SIGE')

@section('content')
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Renovação de Matrícula</h5>
        <a href="{{ route('admin.alunos.index') }}" class="btn btn-sm btn-secondary">
            <i class="bi bi-arrow-left"></i> Voltar
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('erros'))
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <strong>Atenção:</strong> Alguns erros ocorreram durante a renovação.
            <ul class="mb-0 mt-2">
                @foreach(session('erros') as $erro)
                    <li>{{ $erro }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card mb-3">
        <div class="card-body p-2">
            <form method="GET" action="{{ route('admin.alunos.renovacao-matricula') }}" class="row g-2">
                <div class="col-md-4">
                    <label for="ano_letivo_origem_id" class="form-label small mb-0">Ano Letivo Origem</label>
                    <select class="form-select form-select-sm" id="ano_letivo_origem_id" name="ano_letivo_origem_id" required>
                        <option value="">Selecione o Ano Letivo</option>
                        @foreach($anosLetivos as $ano)
                            <option value="{{ $ano->id }}" {{ $anoLetivoOrigemId == $ano->id ? 'selected' : '' }}>
                                {{ $ano->ano }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="ano_letivo_destino_id" class="form-label small mb-0">Ano Letivo Destino</label>
                    <select class="form-select form-select-sm" id="ano_letivo_destino_id" name="ano_letivo_destino_id" required>
                        <option value="">Selecione o Ano Letivo</option>
                        @foreach($anosLetivos as $ano)
                            <option value="{{ $ano->id }}" {{ $anoLetivoDestinoId == $ano->id ? 'selected' : '' }}>
                                {{ $ano->ano }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-sm btn-primary w-100">
                        <i class="bi bi-search"></i> Buscar Alunos
                    </button>
                </div>
            </form>
        </div>
    </div>

    @if($anoLetivoOrigemId && $anoLetivoDestinoId && $alunosParaRenovar->count() > 0)
        <form method="POST" action="{{ route('admin.alunos.renovacao-matricula.processar') }}" id="formRenovacao">
            @csrf
            <input type="hidden" name="ano_letivo_origem_id" value="{{ $anoLetivoOrigemId }}">
            <input type="hidden" name="ano_letivo_destino_id" value="{{ $anoLetivoDestinoId }}">
            
            <div class="card">
                <div class="card-header bg-primary text-white py-2">
                    <h6 class="mb-0">Alunos para Renovação ({{ $alunosParaRenovar->count() }})</h6>
                </div>
                <div class="card-body p-2">
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 30px;">
                                        <input type="checkbox" id="selecionarTodos" onchange="selecionarTodos(this)">
                                    </th>
                                    <th>Código</th>
                                    <th>Nome</th>
                                    <th>Turma Atual</th>
                                    <th>Nova Turma</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($alunosParaRenovar as $aluno)
                                    @php
                                        $turmaAtual = $aluno->turmas->first();
                                    @endphp
                                    <tr>
                                        <td>
                                            <input type="checkbox" name="alunos[{{ $loop->index }}][selecionado]" 
                                                   value="1" class="checkbox-aluno" 
                                                   onchange="toggleTurmaSelect({{ $loop->index }}, this.checked)">
                                        </td>
                                        <td>{{ $aluno->codigo_estudante ?? 'N/A' }}</td>
                                        <td>{{ $aluno->user->name }}</td>
                                        <td>
                                            @if($turmaAtual)
                                                {{ $turmaAtual->codigo }} - {{ $turmaAtual->nome }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            <select name="alunos[{{ $loop->index }}][turma_id]" 
                                                    class="form-select form-select-sm turma-select" 
                                                    disabled required>
                                                <option value="">Selecione a Turma</option>
                                                @foreach($turmasDestino as $turma)
                                                    <option value="{{ $turma->id }}">
                                                        {{ $turma->codigo }} - {{ $turma->nome }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="alunos[{{ $loop->index }}][aluno_id]" value="{{ $aluno->id }}">
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        <button type="submit" class="btn btn-sm btn-success" id="btnRenovar" disabled>
                            <i class="bi bi-check-circle"></i> Renovar Matrículas Selecionadas
                        </button>
                    </div>
                </div>
            </div>
        </form>
    @elseif($anoLetivoOrigemId && $anoLetivoDestinoId)
        <div class="alert alert-info">
            Nenhum aluno encontrado para renovação no ano letivo selecionado.
        </div>
    @endif
</div>

<script>
    function selecionarTodos(checkbox) {
        const checkboxes = document.querySelectorAll('.checkbox-aluno');
        checkboxes.forEach(cb => {
            cb.checked = checkbox.checked;
            const match = cb.name.match(/\[(\d+)\]/);
            if (match) {
                const index = match[1];
                toggleTurmaSelect(index, checkbox.checked);
            }
        });
        atualizarBotaoRenovar();
    }

    function toggleTurmaSelect(index, checked) {
        const turmaSelect = document.querySelector(`select[name="alunos[${index}][turma_id]"]`);
        if (turmaSelect) {
            turmaSelect.disabled = !checked;
            if (!checked) {
                turmaSelect.value = '';
            }
        }
        atualizarBotaoRenovar();
    }

    function atualizarBotaoRenovar() {
        const checkboxes = document.querySelectorAll('.checkbox-aluno:checked');
        const btnRenovar = document.getElementById('btnRenovar');
        if (btnRenovar) {
            btnRenovar.disabled = checkboxes.length === 0;
        }
    }

    document.getElementById('formRenovacao')?.addEventListener('submit', function(e) {
        const checkboxes = document.querySelectorAll('.checkbox-aluno:checked');
        if (checkboxes.length === 0) {
            e.preventDefault();
            alert('Selecione pelo menos um aluno para renovar.');
            return false;
        }
        
        // Verificar se todos os alunos selecionados têm turma selecionada
        let todosComTurma = true;
        checkboxes.forEach(cb => {
            const match = cb.name.match(/\[(\d+)\]/);
            if (match) {
                const index = match[1];
                const turmaSelect = document.querySelector(`select[name="alunos[${index}][turma_id]"]`);
                if (!turmaSelect || !turmaSelect.value) {
                    todosComTurma = false;
                }
            }
        });
        
        if (!todosComTurma) {
            e.preventDefault();
            alert('Todos os alunos selecionados devem ter uma turma destino selecionada.');
            return false;
        }
        
        if (!confirm(`Tem certeza que deseja renovar a matrícula de ${checkboxes.length} aluno(s)?`)) {
            e.preventDefault();
            return false;
        }
    });
</script>
@endsection

