@extends('layouts.app')

@section('title', 'Detalhes do Aluno - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;">{{ $aluno->user->name }}</h5>
                <small class="text-muted">{{ $aluno->codigo_estudante }}</small>
            </div>
            <div class="d-flex gap-1">
                <a href="{{ route('admin.alunos.ficha-inscricao', $aluno) }}" class="btn btn-sm btn-primary" target="_blank" title="Ficha de Inscrição">
                    <i class="bi bi-file-earmark-text"></i> Ficha de Inscrição
                </a>
                <a href="{{ route('admin.alunos.folheto', $aluno) }}" class="btn btn-sm btn-warning" target="_blank" title="Folheto">
                    <i class="bi bi-file-text"></i>
                </a>
                <a href="{{ route('admin.alunos.edit', $aluno) }}" class="btn btn-sm btn-primary">
                    <i class="bi bi-pencil"></i> Editar
                </a>
                <a href="{{ route('admin.alunos.index') }}" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Informações Pessoais</small>
                </div>
                <div style="background: #f8f9fa; padding: 10px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="row mb-2">
                        <div class="col-4 text-center">
                            @if($aluno->foto)
                                <img src="{{ asset('storage/' . $aluno->foto) }}" 
                                     alt="Foto" 
                                     style="max-width: 80px; max-height: 100px; object-fit: cover; border-radius: 4px;">
                            @else
                                <div style="width: 80px; height: 100px; background-color: #e9ecef; border-radius: 4px; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <span class="text-muted" style="font-size: 0.7rem;">Sem foto</span>
                                </div>
                            @endif
                        </div>
                        <div class="col-8">
                            <div class="mb-1"><strong>Nome:</strong> {{ $aluno->user->name }}</div>
                            <div class="mb-1"><strong>Telefone:</strong> {{ $aluno->telefone ?? 'N/A' }}</div>
                            <div class="mb-1"><strong>Status:</strong> 
                                @if($aluno->user && $aluno->user->is_active)
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activo</span>
                                @else
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Bloqueado</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 mb-1"><strong>Endereço:</strong> {{ $aluno->endereco ?? 'N/A' }}</div>
                        <div class="col-12 mb-1"><strong>Data de Nascimento:</strong> {{ $aluno->data_nascimento ? $aluno->data_nascimento->format('d/m/Y') : 'N/A' }}</div>
                        <div class="col-12 mb-1"><strong>Gênero:</strong> 
                            @if($aluno->genero == 'M')
                                Masculino
                            @elseif($aluno->genero == 'F')
                                Feminino
                            @elseif($aluno->genero == 'Outro')
                                Outro
                            @else
                                N/A
                            @endif
                        </div>
                    </div>
                    <div class="d-flex gap-1 mt-2">
                        <a href="{{ route('admin.alunos.view', $aluno) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d1ecf1; color: #0c5460; border: none;">
                            <i class="bi bi-eye"></i> Ver Mais
                        </a>
                        <a href="{{ route('admin.alunos.imprimir-cartao', $aluno) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d1ecf1; color: #0c5460; border: none;" target="_blank">
                            <i class="bi bi-card-heading"></i> Cartão
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Encarregado</small>
                </div>
                <div style="background: #f8f9fa; padding: 10px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="mb-1"><strong>Nome:</strong> {{ $aluno->nome_encarregado ?? 'N/A' }}</div>
                    <div class="mb-1"><strong>Telefone:</strong> {{ $aluno->telefone_encarregado ?? 'N/A' }}</div>
                </div>

                <div class="mb-1 mt-2">
                    <small class="text-muted" style="font-weight: 600;">Acções</small>
                </div>
                <div style="background: #f8f9fa; padding: 10px; border-radius: 4px;">
                    <form action="{{ route('admin.alunos.toggle-status', $aluno) }}" method="POST" class="mb-1">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-sm w-100" style="font-size: 0.75rem; background: {{ $aluno->user && $aluno->user->is_active ? '#fff3cd' : '#d4edda' }}; color: {{ $aluno->user && $aluno->user->is_active ? '#856404' : '#155724' }}; border: none;">
                            <i class="bi bi-{{ $aluno->user && $aluno->user->is_active ? 'lock' : 'unlock' }}"></i>
                            {{ $aluno->user && $aluno->user->is_active ? 'Bloquear Acesso' : 'Ativar Acesso' }}
                        </button>
                    </form>
                    <form action="{{ route('admin.alunos.destroy', $aluno) }}" method="POST"
                          onsubmit="return confirm('Tem certeza que deseja eliminar este aluno?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger w-100" style="font-size: 0.75rem;">
                            <i class="bi bi-trash"></i> Eliminar
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

