@extends('layouts.app')

@section('title', 'Controle de Lançamento de Notas - SGE')

@section('content')
<div class="row">
    <div class="col-md-10">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Controle de Lançamento de Notas por Trimestre</h5>
        </div>
        
        @if($anoLetivo)
        <div class="alert alert-info mb-3" style="font-size: 0.85rem; padding: 10px;">
            <i class="bi bi-info-circle"></i> <strong>Ano Letivo Ativo:</strong> {{ $anoLetivo->ano }}
        </div>
        @endif
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="{{ route('admin.configuracoes.lancamento-notas.update') }}">
                @csrf

                @if($trimestres->isEmpty())
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle"></i> Nenhum trimestre encontrado para o ano letivo ativo.
                    </div>
                @else
                    <div class="mb-3">
                        <h6 style="font-size: 0.9rem; font-weight: 600; margin-bottom: 1rem;">Configuração por Trimestre</h6>
                        
                        @foreach($trimestres as $trimestre)
                            <div class="mb-3 p-3 border rounded" style="background: white;">
                                <div class="form-check form-switch">
                                    <input type="hidden" name="trimestres[{{ $trimestre->id }}]" value="0">
                                    <input class="form-check-input" type="checkbox" 
                                           id="trimestre_{{ $trimestre->id }}" 
                                           name="trimestres[{{ $trimestre->id }}]" 
                                           value="1"
                                           {{ ($lancamentoPorTrimestre[$trimestre->id] ?? true) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="trimestre_{{ $trimestre->id }}" style="font-size: 0.9rem;">
                                        <strong>{{ $trimestre->numero }}º Trimestre - {{ $trimestre->nome }}</strong>
                                    </label>
                                    <small class="form-text text-muted d-block" style="font-size: 0.75rem; margin-top: 3px;">
                                        @if($trimestre->data_inicio && $trimestre->data_fim)
                                            Período: {{ \Carbon\Carbon::parse($trimestre->data_inicio)->format('d/m/Y') }} até {{ \Carbon\Carbon::parse($trimestre->data_fim)->format('d/m/Y') }}
                                        @endif
                                    </small>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <div class="alert alert-info" style="font-size: 0.85rem; padding: 10px;">
                        <i class="bi bi-info-circle"></i> <strong>Informação:</strong> 
                        <ul class="mb-0 mt-2" style="padding-left: 20px;">
                            <li><strong>Liberado (marcado):</strong> Professores podem lançar e alterar notas normalmente neste trimestre.</li>
                            <li><strong>Trancado (desmarcado):</strong> Professores podem apenas visualizar as notas existentes deste trimestre, mas não podem alterá-las.</li>
                        </ul>
                    </div>
                @endif

                <div class="mt-3">
                    <button type="submit" class="btn btn-primary">Salvar Configurações</button>
                    <a href="{{ route('admin.gestao') }}" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
