@extends('layouts.app')

@section('title', 'Criar Disciplina - SGE')

@section('content')
<div class="row">
    <div class="col-md-6 mx-auto">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Nova Disciplina</h5>
            <a href="{{ route('admin.disciplinas.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
        
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.disciplinas.store') }}" method="POST">
                    @csrf

                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome <span class="text-danger">*</span></label>
                        <input type="text" class="form-control form-control-sm @error('nome') is-invalid @enderror" 
                               id="nome" name="nome" value="{{ old('nome') }}" required>
                        @error('nome')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="codigo" class="form-label">Código <span class="text-danger">*</span></label>
                        <input type="text" class="form-control form-control-sm @error('codigo') is-invalid @enderror" 
                               id="codigo" name="codigo" value="{{ old('codigo') }}" required>
                        @error('codigo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="nivel_ensino" class="form-label">Nível de Ensino <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('nivel_ensino') is-invalid @enderror" 
                                id="nivel_ensino" name="nivel_ensino" required>
                            <option value="">Selecione...</option>
                            <option value="PRIMARIO" {{ old('nivel_ensino', 'PRIMARIO') === 'PRIMARIO' ? 'selected' : '' }}>Primário (1ª a 6ª)</option>
                            <option value="SECUNDARIO" {{ old('nivel_ensino') === 'SECUNDARIO' ? 'selected' : '' }}>Secundário (7ª a 12ª)</option>
                        </select>
                        @error('nivel_ensino')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Carga Horária Semanal <span class="text-danger">*</span></label>
                        <div class="row g-2">
                            <div class="col-6">
                                <div class="input-group input-group-sm">
                                    <input type="number" class="form-control @error('carga_horaria_horas') is-invalid @enderror" 
                                           id="carga_horaria_horas" name="carga_horaria_horas" 
                                           value="{{ old('carga_horaria_horas', 0) }}" min="0" max="40" required>
                                    <span class="input-group-text">horas</span>
                                </div>
                                @error('carga_horaria_horas')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-6">
                                <div class="input-group input-group-sm">
                                    <input type="number" class="form-control @error('carga_horaria_minutos') is-invalid @enderror" 
                                           id="carga_horaria_minutos" name="carga_horaria_minutos" 
                                           value="{{ old('carga_horaria_minutos', 0) }}" min="0" max="59" required>
                                    <span class="input-group-text">min</span>
                                </div>
                                @error('carga_horaria_minutos')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <small class="text-muted">Tempo total de aulas por semana (usado para validação e geração de horários)</small>
                    </div>

                    <div class="mb-3 form-check">
                        <input class="form-check-input" type="checkbox" id="Activa" name="Activa" 
                               {{ old('Activa', true) ? 'checked' : '' }}>
                        <label class="form-check-label" for="Activa">
                            Disciplina Activa
                        </label>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="bi bi-check-circle"></i> Criar
                        </button>
                        <a href="{{ route('admin.disciplinas.index') }}" class="btn btn-secondary btn-sm">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

