@extends('layouts.app')

@section('title', 'Editar Disciplina - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Editar Disciplina</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.disciplinas.update', $disciplina) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="nome" class="form-label">Nome <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('nome') is-invalid @enderror" 
                                   id="nome" name="nome" value="{{ old('nome', $disciplina->nome) }}" required>
                            @error('nome')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="codigo" class="form-label">Código <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('codigo') is-invalid @enderror" 
                                   id="codigo" name="codigo" value="{{ old('codigo', $disciplina->codigo) }}" required>
                            @error('codigo')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="nivel_ensino" class="form-label">Nível de Ensino <span class="text-danger">*</span></label>
                            <select class="form-select @error('nivel_ensino') is-invalid @enderror" 
                                    id="nivel_ensino" name="nivel_ensino" required>
                                <option value="">Selecione...</option>
                                <option value="PRIMARIO" {{ old('nivel_ensino', $disciplina->nivel_ensino ?? 'PRIMARIO') === 'PRIMARIO' ? 'selected' : '' }}>Primário (1ª a 6ª)</option>
                                <option value="SECUNDARIO" {{ old('nivel_ensino', $disciplina->nivel_ensino ?? '') === 'SECUNDARIO' ? 'selected' : '' }}>Secundário (7ª a 12ª)</option>
                            </select>
                            @error('nivel_ensino')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Carga Horária Semanal <span class="text-danger">*</span></label>
                            @php
                                $horas = $disciplina->carga_horaria_semanal ? floor($disciplina->carga_horaria_semanal / 60) : 0;
                                $minutos = $disciplina->carga_horaria_semanal ? $disciplina->carga_horaria_semanal % 60 : 0;
                            @endphp
                            <div class="row g-2">
                                <div class="col-6">
                                    <div class="input-group input-group-sm">
                                        <input type="number" class="form-control @error('carga_horaria_horas') is-invalid @enderror" 
                                               id="carga_horaria_horas" name="carga_horaria_horas" 
                                               value="{{ old('carga_horaria_horas', $horas) }}" min="0" max="40" required>
                                        <span class="input-group-text">h</span>
                                    </div>
                                    @error('carga_horaria_horas')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-6">
                                    <div class="input-group input-group-sm">
                                        <input type="number" class="form-control @error('carga_horaria_minutos') is-invalid @enderror" 
                                               id="carga_horaria_minutos" name="carga_horaria_minutos" 
                                               value="{{ old('carga_horaria_minutos', $minutos) }}" min="0" max="59" required>
                                        <span class="input-group-text">min</span>
                                    </div>
                                    @error('carga_horaria_minutos')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <small class="text-muted">Tempo total de aulas por semana (usado para validação e geração de horários)</small>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="Activa" name="Activa" 
                                       {{ old('Activa', $disciplina->ativa) ? 'checked' : '' }}>
                                <label class="form-check-label" for="Activa">
                                    Disciplina Activa
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.disciplinas.index') }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left me-1"></i> Voltar
                        </a>
                        <button type="submit" class="btn btn-primary-custom">
                            <i class="bi bi-check-circle me-1"></i> Atualizar Disciplina
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

