@extends('layouts.app')

@section('title', 'Funcionários - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Funcionários</h5>
            <a href="{{ route('admin.funcionarios-servicos.create') }}" class="btn btn-sm btn-primary">
                <i class="bi bi-plus-circle"></i> Novo
            </a>
        </div>

        <form method="GET" action="{{ route('admin.funcionarios-servicos.index') }}" class="mb-2 row g-2">
            <div class="col-md-5">
                <input type="text" class="form-control form-control-sm" name="search"
                       value="{{ request('search') }}" placeholder="Pesquisar por nome/cargo/telefone...">
            </div>
            <div class="col-md-3">
                <select class="form-select form-select-sm" name="cargo">
                    <option value="">Todos os cargos</option>
                    @foreach($cargosExistentes as $cargo)
                        <option value="{{ $cargo }}" {{ request('cargo') === $cargo ? 'selected' : '' }}>{{ $cargo }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select form-select-sm" name="status">
                    <option value="">Status</option>
                    <option value="ATIVO" {{ request('status') === 'ATIVO' ? 'selected' : '' }}>Ativo</option>
                    <option value="INATIVO" {{ request('status') === 'INATIVO' ? 'selected' : '' }}>Inativo</option>
                </select>
            </div>
            <div class="col-md-2 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
                @if(request()->query())
                    <a href="{{ route('admin.funcionarios-servicos.index') }}" class="btn btn-sm btn-secondary">Limpar</a>
                @endif
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;">Nome</th>
                        <th style="padding: 6px;">Cargo</th>
                        <th style="padding: 6px;">Salário Base</th>
                        <th style="padding: 6px;">Dep.</th>
                        <th style="padding: 6px;">Status</th>
                        <th style="padding: 6px;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($funcionarios as $f)
                        <tr>
                            <td style="padding: 5px;">{{ $f->nome }}</td>
                            <td style="padding: 5px;">{{ $f->cargo }}</td>
                            <td style="padding: 5px;"><strong>{{ number_format($f->salario_base ?? 0, 2, ',', '.') }}</strong></td>
                            <td style="padding: 5px;"><span class="badge bg-secondary">{{ $f->numero_dependentes ?? 0 }}</span></td>
                            <td style="padding: 5px;">
                                @if($f->is_active)
                                    <span class="badge bg-success">Ativo</span>
                                @else
                                    <span class="badge bg-danger">Inativo</span>
                                @endif
                            </td>
                            <td style="padding: 5px;">
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('admin.funcionarios-servicos.show', $f) }}" class="btn btn-outline-primary" title="Ver">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.funcionarios-servicos.edit', $f) }}" class="btn btn-outline-secondary" title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('admin.funcionarios-servicos.toggle-status', $f) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="btn btn-outline-warning" title="Ativar/Desativar">
                                            <i class="bi bi-toggle2-on"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('admin.funcionarios-servicos.destroy', $f) }}" method="POST" class="d-inline" onsubmit="return confirm('Eliminar este funcionário?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-outline-danger" title="Eliminar">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted" style="padding: 10px;">Nenhum funcionário encontrado.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-2">
            {{ $funcionarios->links() }}
        </div>
    </div>
</div>
@endsection

